/*
 * Decompiled with CFR 0.152.
 */
package com.laputapp.ui;

import android.content.Context;
import android.os.Bundle;
import android.support.v4.view.ViewCompat;
import android.support.v4.widget.SwipeRefreshLayout;
import android.support.v4.widget.TextViewCompat;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;
import android.widget.ViewSwitcher;
import com.laputapp.R;
import com.laputapp.http.Callbacks;
import com.laputapp.http.DataLoader;
import com.laputapp.http.Response;
import com.laputapp.ui.BaseFragment;
import com.laputapp.ui.adapter.RecyclerAdapter;
import com.laputapp.utilities.Lists;
import com.laputapp.utilities.UiUtilities;
import com.laputapp.widget.DelegatedSwipeRefreshLayout;
import com.laputapp.widget.ViewDelegate;
import java.util.ArrayList;
import retrofit.RetrofitError;

public abstract class RecyclerFragment<T>
extends BaseFragment
implements SwipeRefreshLayout.OnRefreshListener,
ViewDelegate,
DataLoader.Loader<T>,
DataLoader.KeyExtractor<T>,
Callbacks.RequestCallback<ArrayList<T>> {
    private static final long DEFAULT_PAGE = 1L;
    private static final long DEFAULT_PAGE_SIZE = 10L;
    ViewSwitcher mSwitcherLoading;
    ViewSwitcher mSwitcherContent;
    RecyclerView mRecyclerView;
    DelegatedSwipeRefreshLayout mSwipeRefreshLayout;
    TextView mEmptyView;
    LinearLayout mBtnContainerView;
    private RecyclerAdapter<T> mAdapter;
    private boolean mDataHasLoaded = false;
    protected ArrayList<T> mItems = Lists.newArrayList();
    private DataLoader<T> mDataLoader;

    protected abstract RecyclerAdapter<T> createRecyclerViewAdapter();

    protected long createDefaultPage() {
        return 1L;
    }

    protected long createDefaultPageSize() {
        return 10L;
    }

    protected int[] getColorSchemeResources() {
        return null;
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.mAdapter = this.createRecyclerViewAdapter();
        this.mDataLoader = new DataLoader((DataLoader.Loader)this, (DataLoader.KeyExtractor)this, this.createDefaultPage(), this.createDefaultPageSize());
        this.mDataLoader.addRequestCallback((Callbacks.RequestCallback)this);
    }

    @Override
    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        return inflater.inflate(R.layout.fragment_recycler_view, container, false);
    }

    @Override
    public void onViewCreated(View view, Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        this.mEmptyView = (TextView)UiUtilities.getView(view, 16908292);
        this.mSwitcherLoading = (ViewSwitcher)UiUtilities.getView(view, R.id.view_loading_switcher);
        this.mSwitcherContent = (ViewSwitcher)UiUtilities.getView(view, R.id.view_content_switcher);
        this.mRecyclerView = (RecyclerView)UiUtilities.getView(view, R.id.recycler_view);
        this.mSwipeRefreshLayout = (DelegatedSwipeRefreshLayout)((Object)UiUtilities.getView(view, R.id.swipe_refresh_layout));
        this.mBtnContainerView = (LinearLayout)UiUtilities.getView(view, R.id.view_btns);
        this.setupRefreshLayout();
        this.setupRecyclerView();
    }

    public void onActivityCreated(Bundle savedInstanceState) {
        super.onActivityCreated(savedInstanceState);
        if (!this.mItems.isEmpty()) {
            this.updateRecyclerView();
        }
        if (!this.mDataHasLoaded) {
            this.mDataLoader.refresh();
        }
    }

    public void setupRefreshLayout() {
        int[] colors = this.getColorSchemeResources();
        if (colors != null) {
            this.mSwipeRefreshLayout.setColorSchemeColors(colors);
        }
        this.mSwipeRefreshLayout.setOnRefreshListener(this);
        this.mSwipeRefreshLayout.setViewDelegate(this);
    }

    private void setupRecyclerView() {
        this.mRecyclerView.setHasFixedSize(true);
        this.mRecyclerView.setAdapter(this.mAdapter);
        this.mRecyclerView.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager((Context)this.getActivity()));
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        this.mDataLoader.removeRequestCallback();
        this.mDataLoader = null;
        this.mAdapter = null;
    }

    protected void startRefreshing() {
        if (!this.isVisible()) {
            return;
        }
        ViewCompat.postOnAnimation((View)this.mSwipeRefreshLayout, (Runnable)new Runnable(){

            @Override
            public void run() {
                RecyclerFragment.this.mSwipeRefreshLayout.setRefreshing(true);
            }
        });
    }

    protected void stopRefreshing() {
        if (!this.isVisible()) {
            return;
        }
        this.mSwipeRefreshLayout.setRefreshing(false);
    }

    protected RecyclerFragment showLoadingView() {
        if (!this.isVisible()) {
            return this;
        }
        if (this.mSwitcherLoading.getCurrentView().getId() == R.id.view_content_switcher) {
            this.mSwitcherLoading.showPrevious();
        }
        return this;
    }

    protected RecyclerFragment showContentView() {
        if (!this.isVisible()) {
            return this;
        }
        if (this.mSwitcherLoading.getCurrentView().getId() == R.id.view_loading) {
            this.mSwitcherLoading.showNext();
        }
        if (this.mSwitcherContent.getCurrentView().getId() != R.id.view_recycler) {
            this.mSwitcherContent.showPrevious();
        }
        return this;
    }

    protected RecyclerFragment showEmptyView() {
        if (!this.isVisible()) {
            return this;
        }
        if (this.mSwitcherLoading.getCurrentView().getId() == R.id.view_loading) {
            this.mSwitcherLoading.showNext();
        }
        if (this.mSwitcherContent.getCurrentView().getId() == R.id.view_recycler) {
            this.mSwitcherContent.showNext();
        }
        return this;
    }

    public void onRefresh() {
        this.mDataLoader.refresh();
    }

    @Override
    public boolean canChildScrollUp() {
        return ViewCompat.canScrollVertically((View)this.mRecyclerView, (int)-1);
    }

    protected void updateRecyclerView() {
        if (!this.isVisible()) {
            return;
        }
        this.mAdapter.updateData(this.mItems);
        if (this.mItems.isEmpty()) {
            this.showEmptyView();
        } else {
            this.showContentView();
        }
    }

    public DataLoader<T> getDataLoader() {
        return this.mDataLoader;
    }

    public DelegatedSwipeRefreshLayout getRefreshLayout() {
        return this.mSwipeRefreshLayout;
    }

    public RecyclerView getRecyclerView() {
        return this.mRecyclerView;
    }

    public void beforeRefresh() {
    }

    public void beforeLoadMore() {
    }

    public T register(T resource) {
        return resource;
    }

    public void onRequestComplete(Response<ArrayList<T>> response) {
        this.mItems = this.mDataLoader.getResources();
        this.mDataHasLoaded = !this.mItems.isEmpty();
    }

    public void onRequestFailure(Response<ArrayList<T>> response) {
        this.mDataHasLoaded = false;
    }

    public void onRequestFailure(RetrofitError error) {
        this.mDataHasLoaded = false;
    }

    public void onRequestNetworkError() {
        this.mDataHasLoaded = false;
    }

    public void onFinish() {
        this.stopRefreshing();
        this.updateRecyclerView();
    }

    public boolean canCache() {
        return false;
    }

    public void handleLocalCache(ArrayList<T> data) {
    }

    public void onCacheLoaded(ArrayList<T> localData) {
        if (localData == null || localData.isEmpty()) {
            return;
        }
        for (T data : localData) {
            this.register(data);
        }
        this.mItems.addAll(localData);
        if (!this.mItems.isEmpty()) {
            this.updateRecyclerView();
        }
    }

    public ArrayList<T> getItems() {
        return this.mItems;
    }

    public RecyclerFragment setEmptyText(int resId) {
        this.setEmptyText(this.getString(resId));
        return this;
    }

    public RecyclerFragment setEmptyText(String empty) {
        this.mEmptyView.setText((CharSequence)empty);
        return this;
    }

    public RecyclerFragment setEmptyTextColor(int color2) {
        this.mEmptyView.setTextColor(color2);
        return this;
    }

    public RecyclerFragment setEmptyDrawablePadding(int pad) {
        this.mEmptyView.setCompoundDrawablePadding(pad);
        return this;
    }

    public RecyclerFragment setEmptyTopDrawable(int top) {
        return this.setEmptyTopDrawable(0, top, 0, 0);
    }

    public RecyclerFragment setEmptyTopDrawable(int start, int top, int end, int bottom) {
        TextViewCompat.setCompoundDrawablesRelativeWithIntrinsicBounds((TextView)this.mEmptyView, (int)start, (int)top, (int)end, (int)bottom);
        return this;
    }

    public LinearLayout getBtnContainerView() {
        return this.mBtnContainerView;
    }
}

