/*
 * Decompiled with CFR 0.152.
 */
package com.laputapp.ui.adapter;

import android.content.Context;
import android.support.annotation.NonNull;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import com.laputapp.ui.adapter.PositionConsumer;
import java.util.ArrayList;
import java.util.List;

public abstract class GeneralAdapter<T> {
    public static final int NO_POSITION = -1;
    private ViewGroup mParent;
    private List<View> mChildren;
    private List<T> mData;

    public GeneralAdapter(@NonNull ViewGroup parent) {
        this.mParent = parent;
        this.mChildren = new ArrayList<View>();
    }

    public int getCount() {
        return this.mData != null ? this.mData.size() : 0;
    }

    public T getItem(int position) {
        return this.mData.get(position);
    }

    public View getView(int position, View convertView, ViewGroup parent) {
        ViewHolder<T> viewHolder;
        if (convertView == null) {
            convertView = LayoutInflater.from((Context)parent.getContext()).inflate(this.getItemLayoutResId(position), parent, false);
            viewHolder = this.onCreateViewHolder(convertView);
            convertView.setTag(viewHolder);
            this.mChildren.add(convertView);
        } else {
            viewHolder = (ViewHolder<T>)convertView.getTag();
        }
        viewHolder.bind(this.getItem(position), position);
        return convertView;
    }

    public abstract ViewHolder<T> onCreateViewHolder(View var1);

    public void updateData(List<T> data) {
        this.mData = data;
        this.notifyDataSetChanged();
    }

    public void notifyDataSetChanged() {
        this.mParent.removeAllViews();
        for (int i = 0; i < this.getCount(); ++i) {
            View child = this.getView(i, i < this.mChildren.size() ? this.mChildren.get(i) : null, this.mParent);
            this.mParent.addView(child, i);
        }
    }

    public abstract int getItemLayoutResId(int var1);

    public static class ViewHolder<T> {
        public final View itemView;
        private int mPosition = -1;

        public ViewHolder(View itemView) {
            this.itemView = itemView;
        }

        public Context getContext() {
            return this.itemView.getContext();
        }

        public int getPosition() {
            return this.mPosition;
        }

        public void bind(T item, int position) {
            this.mPosition = position;
            if (item instanceof PositionConsumer) {
                ((PositionConsumer)item).setPosition(position);
            }
        }
    }
}

