/*
 * Decompiled with CFR 0.152.
 */
package com.laputapp.ui.adapter;

import android.content.Context;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import com.laputapp.ui.adapter.PositionConsumer;
import java.util.ArrayList;

public abstract class RecyclerAdapter<T>
extends RecyclerView.Adapter<ViewHolder<T>> {
    private final Context mContext;
    private final LayoutInflater mInflater;
    private ArrayList<T> mData;

    public RecyclerAdapter(Context context) {
        this.mContext = context;
        this.mInflater = LayoutInflater.from((Context)context);
        this.mData = new ArrayList();
    }

    public void updateData(ArrayList<T> data) {
        this.setData(data);
        this.notifyDataSetChanged();
    }

    public void setData(ArrayList<T> data) {
        this.mData.clear();
        if (data != null) {
            this.mData.addAll(data);
        }
    }

    public LayoutInflater getLayoutInflater() {
        return this.mInflater;
    }

    public Context getContext() {
        return this.mContext;
    }

    public void onBindViewHolder(ViewHolder<T> holder, int position) {
        holder.bind(this.getItem(position), position);
    }

    public T getItem(int position) {
        return this.mData.get(position);
    }

    public int getItemCount() {
        return this.mData == null ? 0 : this.mData.size();
    }

    public static class ViewHolder<T>
    extends RecyclerView.ViewHolder {
        public ViewHolder(View itemView) {
            super(itemView);
        }

        public Context getContext() {
            return this.itemView.getContext();
        }

        public void bind(T item, int position) {
            if (item instanceof PositionConsumer) {
                ((PositionConsumer)item).setPosition(position);
            }
        }
    }
}

