/*
 * Decompiled with CFR 0.152.
 */
package com.laputapp.ui.decorator;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.support.v7.widget.RecyclerView;
import android.view.View;
import com.laputapp.R;
import com.laputapp.utilities.ViewCompat;

public class DividerItemDecoration
extends RecyclerView.ItemDecoration {
    private static final int DEFAULT_DIVIDER_HEIGHT = 1;
    public static final int HORIZONTAL_LIST = 0;
    public static final int VERTICAL_LIST = 1;
    private int mOrientation;
    private int padding;
    private int startpadding;
    private int endpadding;
    private int dividerHeight;
    private Context mContext;
    private Paint mPaddingPaint;
    private Paint mDividerPaint;

    public DividerItemDecoration(Context context, int orientation) {
        this(context, orientation, -1, -1);
    }

    public DividerItemDecoration(Context context, int orientation, int padding, int dividerHeight) {
        this.setOrientation(orientation);
        this.mContext = context;
        this.init();
        if (padding != -1) {
            this.padding = padding;
        }
        this.updatePaddint();
        if (dividerHeight != -1) {
            this.dividerHeight = dividerHeight;
        }
    }

    public DividerItemDecoration(Context context, int orientation, int startpadding, int endpadding, int dividerHeight) {
        this.setOrientation(orientation);
        this.mContext = context;
        this.init();
        if (startpadding != -1) {
            this.startpadding = startpadding;
        }
        if (endpadding != -1) {
            this.endpadding = endpadding;
        }
        if (dividerHeight != -1) {
            this.dividerHeight = dividerHeight;
        }
    }

    private void updatePaddint() {
        this.startpadding = this.padding;
        this.endpadding = this.padding;
    }

    private void init() {
        this.padding = this.mContext.getResources().getDimensionPixelSize(R.dimen.activity_horizontal_margin);
        this.updatePaddint();
        this.dividerHeight = 1;
        this.mPaddingPaint = new Paint(1);
        this.mPaddingPaint.setColor(this.mContext.getResources().getColor(17170443, null));
        this.mPaddingPaint.setStyle(Paint.Style.FILL);
        this.mDividerPaint = new Paint(1);
        this.mDividerPaint.setColor(this.mContext.getResources().getColor(R.color.divider_color, null));
        this.mDividerPaint.setStyle(Paint.Style.FILL);
    }

    public void setOrientation(int orientation) {
        if (orientation != 0 && orientation != 1) {
            throw new IllegalArgumentException("invalid orientation");
        }
        this.mOrientation = orientation;
    }

    public void onDraw(Canvas c, RecyclerView parent, RecyclerView.State state) {
        super.onDraw(c, parent, state);
        if (this.mOrientation == 1) {
            this.drawVertical(c, parent);
        } else {
            this.drawHorizontal(c, parent);
        }
    }

    public void drawVertical(Canvas c, RecyclerView parent) {
        int left = parent.getPaddingLeft();
        int right = parent.getWidth() - parent.getPaddingRight();
        int childCount = parent.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            View child = parent.getChildAt(i);
            RecyclerView.LayoutParams params = (RecyclerView.LayoutParams)child.getLayoutParams();
            int top = child.getBottom() + params.bottomMargin + Math.round(ViewCompat.getTranslationY((View)child));
            int bottom = top + this.dividerHeight;
            c.drawRect((float)left, (float)top, (float)(left + this.startpadding), (float)bottom, this.mPaddingPaint);
            c.drawRect((float)(right - this.endpadding), (float)top, (float)right, (float)bottom, this.mPaddingPaint);
            c.drawRect((float)(left + this.startpadding), (float)top, (float)(right - this.endpadding), (float)bottom, this.mDividerPaint);
        }
    }

    public void drawHorizontal(Canvas c, RecyclerView parent) {
        int top = parent.getPaddingTop();
        int bottom = parent.getHeight() - parent.getPaddingBottom();
        int childCount = parent.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            View child = parent.getChildAt(i);
            RecyclerView.LayoutParams params = (RecyclerView.LayoutParams)child.getLayoutParams();
            int left = child.getRight() + params.rightMargin + Math.round(ViewCompat.getTranslationX((View)child));
            int right = left + this.dividerHeight;
            c.drawRect((float)left, (float)top, (float)right, (float)(top + this.startpadding), this.mPaddingPaint);
            c.drawRect((float)left, (float)(bottom - this.endpadding), (float)right, (float)bottom, this.mPaddingPaint);
            c.drawRect((float)left, (float)(top + this.startpadding), (float)right, (float)(bottom - this.endpadding), this.mDividerPaint);
        }
    }

    public void getItemOffsets(Rect outRect, View view, RecyclerView parent, RecyclerView.State state) {
        super.getItemOffsets(outRect, view, parent, state);
        if (this.mOrientation == 1) {
            if (parent.getChildAdapterPosition(view) != parent.getAdapter().getItemCount() - 1) {
                outRect.set(0, 0, 0, this.dividerHeight);
            } else {
                outRect.set(0, 0, 0, 0);
            }
        } else if (parent.getChildAdapterPosition(view) != parent.getAdapter().getItemCount() - 1) {
            outRect.set(0, 0, this.dividerHeight, 0);
        } else {
            outRect.set(0, 0, 0, 0);
        }
    }
}

