/*
 * Decompiled with CFR 0.152.
 */
package com.laputapp.utilities;

import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;

public class BitmapUtil {
    private BitmapUtil() {
    }

    public static int getSmallerExtentFromBytes(byte[] bytes) {
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeByteArray((byte[])bytes, (int)0, (int)bytes.length, (BitmapFactory.Options)options);
        return Math.min(options.outWidth, options.outHeight);
    }

    public static int findOptimalSampleSize(int originalSmallerExtent, int targetExtent) {
        if (targetExtent < 1) {
            return 1;
        }
        if (originalSmallerExtent < 1) {
            return 1;
        }
        int extent = originalSmallerExtent;
        int sampleSize = 1;
        while ((float)(extent >> 1) >= (float)targetExtent * 0.8f) {
            sampleSize <<= 1;
            extent >>= 1;
        }
        return sampleSize;
    }

    public static Bitmap decodeBitmapFromBytes(byte[] bytes, int sampleSize) {
        BitmapFactory.Options options;
        if (sampleSize <= 1) {
            options = null;
        } else {
            options = new BitmapFactory.Options();
            options.inSampleSize = sampleSize;
        }
        return BitmapFactory.decodeByteArray((byte[])bytes, (int)0, (int)bytes.length, (BitmapFactory.Options)options);
    }

    public static Drawable getRotatedDrawable(Resources resources, int resourceId, float angle) {
        Bitmap original = BitmapFactory.decodeResource((Resources)resources, (int)resourceId);
        Bitmap rotated = Bitmap.createBitmap((int)original.getWidth(), (int)original.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas tempCanvas = new Canvas(rotated);
        tempCanvas.rotate(angle, (float)(original.getWidth() / 2), (float)(original.getHeight() / 2));
        tempCanvas.drawBitmap(original, 0.0f, 0.0f, null);
        return new BitmapDrawable(resources, rotated);
    }
}

