/*
 * Decompiled with CFR 0.152.
 */
package com.laputapp.utilities;

import android.app.Activity;
import android.content.Context;
import android.graphics.Paint;
import android.graphics.Rect;
import android.util.DisplayMetrics;
import android.view.Display;
import java.lang.reflect.Method;

public final class DeviceScreenUtils {
    private static DisplayMetrics metrics;

    public static DisplayMetrics getDisplayMetrics(Context context) {
        if (metrics == null) {
            metrics = context.getResources().getDisplayMetrics();
        }
        return metrics;
    }

    public static float getDensity(Context context) {
        if (metrics == null) {
            DeviceScreenUtils.getDisplayMetrics(context);
        }
        return DeviceScreenUtils.metrics.density;
    }

    public static float getScaledDensity(Context context) {
        if (metrics == null) {
            DeviceScreenUtils.getDisplayMetrics(context);
        }
        return DeviceScreenUtils.metrics.scaledDensity;
    }

    public static int getScreenWidth(Context context) {
        if (metrics == null) {
            DeviceScreenUtils.getDisplayMetrics(context);
        }
        return DeviceScreenUtils.metrics.widthPixels;
    }

    public static int getScreenHeight(Context context) {
        if (metrics == null) {
            DeviceScreenUtils.getDisplayMetrics(context);
        }
        return DeviceScreenUtils.metrics.heightPixels;
    }

    public static int px2dp(float pxValue, Activity activity) {
        if (metrics == null) {
            DeviceScreenUtils.getDisplayMetrics((Context)activity);
        }
        return (int)(pxValue / DeviceScreenUtils.metrics.density + 0.5f);
    }

    public static int dp2px(float dipValue, Activity activity) {
        if (metrics == null) {
            DeviceScreenUtils.getDisplayMetrics((Context)activity);
        }
        return (int)(dipValue * DeviceScreenUtils.metrics.density + 0.5f);
    }

    public static int dp2px(float dpValue, Context context) {
        float scale = context.getResources().getDisplayMetrics().density;
        return (int)(dpValue * scale + 0.5f);
    }

    public static int px2sp(float pxValue, Activity activity) {
        if (metrics == null) {
            DeviceScreenUtils.getDisplayMetrics((Context)activity);
        }
        return (int)(pxValue / DeviceScreenUtils.metrics.scaledDensity + 0.5f);
    }

    public static int sp2px(float spValue, Activity activity) {
        if (metrics == null) {
            DeviceScreenUtils.getDisplayMetrics((Context)activity);
        }
        return (int)(spValue * DeviceScreenUtils.metrics.scaledDensity + 0.5f);
    }

    public static float getTextLength(float textSize, String text) {
        Paint paint = new Paint();
        paint.setTextSize(textSize);
        return paint.measureText(text);
    }

    public static int[] getRealMetrics(Activity activity) {
        int[] dpi = new int[2];
        Display display = activity.getWindowManager().getDefaultDisplay();
        DisplayMetrics dm = new DisplayMetrics();
        try {
            Class<?> c = Class.forName("android.view.Display");
            Method method = c.getMethod("getRealMetrics", DisplayMetrics.class);
            method.invoke((Object)display, dm);
            dpi[0] = dm.widthPixels;
            dpi[1] = dm.heightPixels;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return dpi;
    }

    public static int getStatusHeight(Activity activity) {
        Rect rect = new Rect();
        activity.getWindow().getDecorView().getWindowVisibleDisplayFrame(rect);
        return rect.top;
    }
}

