/*
 * Decompiled with CFR 0.152.
 */
package com.laputapp.utilities;

import android.annotation.SuppressLint;
import android.bluetooth.BluetoothAdapter;
import android.content.ContentResolver;
import android.content.Context;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.os.Build;
import android.provider.Settings;
import android.telephony.TelephonyManager;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public final class IdDevice {
    @SuppressLint(value={"DefaultLocale"})
    public static String getDeviceID(Context context) {
        String m_szLongID = IdDevice.getIMEI(context) + IdDevice.getBTMACAddress() + IdDevice.getAndroidId(context) + IdDevice.getLocalMacAddress(context) + IdDevice.getPseudoUniqueID();
        MessageDigest m = null;
        try {
            m = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        m.update(m_szLongID.getBytes(), 0, m_szLongID.length());
        byte[] p_md5Data = m.digest();
        String m_szUniqueID = new String();
        for (int i = 0; i < p_md5Data.length; ++i) {
            int b = 0xFF & p_md5Data[i];
            if (b <= 15) {
                m_szUniqueID = m_szUniqueID + "0";
            }
            m_szUniqueID = m_szUniqueID + Integer.toHexString(b);
        }
        m_szUniqueID = m_szUniqueID.toUpperCase();
        return m_szUniqueID;
    }

    public static String getBTMACAddress() {
        try {
            BluetoothAdapter m_BluetoothAdapter = null;
            m_BluetoothAdapter = BluetoothAdapter.getDefaultAdapter();
            String m_szBTMAC = m_BluetoothAdapter.getAddress();
            return m_szBTMAC;
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    public static String getAndroidId(Context context) {
        return Settings.Secure.getString((ContentResolver)context.getContentResolver(), (String)"android_id");
    }

    public static String getPseudoUniqueID() {
        try {
            String m_szDevIDShort = "35" + Build.BOARD.length() % 10 + Build.BRAND.length() % 10 + Build.CPU_ABI.length() % 10 + Build.DEVICE.length() % 10 + Build.DISPLAY.length() % 10 + Build.HOST.length() % 10 + Build.ID.length() % 10 + Build.MANUFACTURER.length() % 10 + Build.MODEL.length() % 10 + Build.PRODUCT.length() % 10 + Build.TAGS.length() % 10 + Build.TYPE.length() % 10 + Build.USER.length() % 10;
            return m_szDevIDShort;
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    public static String getIMEI(Context context) {
        try {
            TelephonyManager TelephonyMgr = (TelephonyManager)context.getSystemService("phone");
            String szImei = TelephonyMgr.getDeviceId();
            return szImei;
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    public static String getLocalMacAddress(Context context) {
        try {
            WifiManager wifi = (WifiManager)context.getSystemService("wifi");
            WifiInfo info = wifi.getConnectionInfo();
            return info.getMacAddress();
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }
}

