/*
 * Decompiled with CFR 0.152.
 */
package com.laputapp.utilities;

import android.app.Activity;
import android.content.Context;
import android.os.IBinder;
import android.view.View;
import android.view.inputmethod.InputMethodManager;

public final class InputMethodUtils {
    public static void showSoftInputMethod(Context context) {
        try {
            InputMethodManager inputMethodManager = (InputMethodManager)context.getSystemService("input_method");
            inputMethodManager.toggleSoftInput(0, 2);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void setSoftInputMode(Activity activity, int flag) {
        activity.getWindow().setSoftInputMode(flag);
    }

    public static void showSoftInputMethod(Context context, View view) {
        InputMethodManager iMM = (InputMethodManager)context.getSystemService("input_method");
        iMM.showSoftInput(view, 0);
    }

    public static void hideSoftInputMethod(Context context, IBinder binder) {
        InputMethodManager imm = (InputMethodManager)context.getSystemService("input_method");
        if (imm.isActive()) {
            imm.hideSoftInputFromWindow(binder, 0);
        }
    }

    public static boolean isSoftKeyboardActive(Context context, View view) {
        InputMethodManager inputMethodManager = (InputMethodManager)context.getSystemService("input_method");
        return inputMethodManager.isActive(view);
    }

    public static boolean isSoftKeyboardActive(Context context) {
        InputMethodManager inputMethodManager = (InputMethodManager)context.getSystemService("input_method");
        return inputMethodManager.isActive();
    }
}

