/*
 * Decompiled with CFR 0.152.
 */
package com.laputapp.utilities;

import android.app.Activity;
import android.content.Context;
import android.widget.Toast;
import com.laputapp.http.BaseHttpCallback;
import com.laputapp.http.Response;
import java.lang.ref.WeakReference;
import retrofit.RetrofitError;

public abstract class MessageHttpCallback<T>
extends BaseHttpCallback<T> {
    private WeakReference<Activity> mActivityRef;
    private final boolean mShowSuccessMessage;

    public MessageHttpCallback(Activity activity) {
        this(activity, false);
    }

    public MessageHttpCallback(Activity activity, boolean showSuccessMessage) {
        this.mActivityRef = new WeakReference<Activity>(activity);
        this.mShowSuccessMessage = showSuccessMessage;
    }

    public Activity getActivity() {
        if (this.mActivityRef.get() == null || ((Activity)this.mActivityRef.get()).isFinishing()) {
            return null;
        }
        return (Activity)this.mActivityRef.get();
    }

    public void onRequestComplete(Response<T> response) {
        super.onRequestComplete(response);
        Activity context = this.getActivity();
        if (context != null && this.mShowSuccessMessage) {
            Toast.makeText((Context)context, (CharSequence)response.mMsg, (int)0).show();
        }
    }

    public void onRequestFailure(RetrofitError error) {
        super.onRequestFailure(error);
        Activity context = this.getActivity();
        if (context != null) {
            Toast.makeText((Context)context, (CharSequence)error.getMessage(), (int)0).show();
        }
    }

    public void onRequestNetworkError() {
        super.onRequestNetworkError();
        Activity context = this.getActivity();
        if (context != null) {
            Toast.makeText((Context)context, (CharSequence)"\u5f53\u524d\u7f51\u7edc\u4e0d\u53ef\u7528\uff0c\u8bf7\u68c0\u67e5\u60a8\u7684\u7f51\u7edc\u8bbe\u7f6e", (int)0).show();
        }
    }

    public void onRequestFailure(Response<T> response) {
        super.onRequestFailure(response);
        Activity context = this.getActivity();
        if (response.mCode == 401) {
            this.showNotAuthenticDialog();
        } else if (context != null) {
            Toast.makeText((Context)context, (CharSequence)response.mMsg, (int)0).show();
        }
    }

    abstract void showNotAuthenticDialog();
}

