/*
 * Decompiled with CFR 0.152.
 */
package com.laputapp.utilities;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.app.Activity;
import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.util.TypedValue;
import android.view.View;

public final class UiUtilities {
    private static final int[] RES_IDS_ACTION_BAR_SIZE = new int[]{16843499};

    public static boolean isTablet(Context context) {
        return (context.getResources().getConfiguration().screenLayout & 0xF) >= 3;
    }

    public static int calculateActionBarSize(Context context) {
        if (context == null) {
            return 0;
        }
        Resources.Theme curTheme = context.getTheme();
        if (curTheme == null) {
            return 0;
        }
        TypedArray att = curTheme.obtainStyledAttributes(RES_IDS_ACTION_BAR_SIZE);
        if (att == null) {
            return 0;
        }
        float size = att.getDimension(0, 0.0f);
        att.recycle();
        return (int)size;
    }

    public static boolean hasICS() {
        return Build.VERSION.SDK_INT >= 14;
    }

    public static boolean hasHoneycomb() {
        return Build.VERSION.SDK_INT >= 11;
    }

    public static boolean hasHoneycombMR1() {
        return Build.VERSION.SDK_INT >= 12;
    }

    public static boolean hasJellyBean() {
        return Build.VERSION.SDK_INT >= 16;
    }

    public static boolean hasJellyBeanMR1() {
        return Build.VERSION.SDK_INT >= 17;
    }

    public static boolean hasLollipop() {
        return Build.VERSION.SDK_INT >= 21;
    }

    public static <T extends View> T getViewOrNull(Activity parent, int viewId) {
        return (T)parent.findViewById(viewId);
    }

    public static <T extends View> T getViewOrNull(View parent, int viewId) {
        return (T)parent.findViewById(viewId);
    }

    public static <T extends View> T getView(Activity parent, int viewId) {
        return (T)UiUtilities.checkView(parent.findViewById(viewId));
    }

    public static <T extends View> T getView(View parent, int viewId) {
        return (T)UiUtilities.checkView(parent.findViewById(viewId));
    }

    private static View checkView(View v) {
        if (v == null) {
            throw new IllegalArgumentException("View doesn't exist");
        }
        return v;
    }

    public static void setVisibilitySafe(View v, int visibility) {
        if (v != null) {
            v.setVisibility(visibility);
        }
    }

    public static void setVisibilitySafe(Activity parent, int viewId, int visibility) {
        UiUtilities.setVisibilitySafe(parent.findViewById(viewId), visibility);
    }

    public static void setVisibilitySafe(View parent, int viewId, int visibility) {
        UiUtilities.setVisibilitySafe(parent.findViewById(viewId), visibility);
    }

    @SuppressLint(value={"NewApi"})
    public static void setBackgroundCompat(View view, Drawable drawable) {
        if (UiUtilities.hasJellyBean()) {
            view.setBackground(drawable);
        } else {
            view.setBackgroundDrawable(drawable);
        }
    }

    public static int resolveAttributeToResourceId(Resources.Theme theme, int attributeResId) {
        TypedValue outValue = new TypedValue();
        theme.resolveAttribute(attributeResId, outValue, true);
        return outValue.resourceId;
    }

    @TargetApi(value=17)
    public static boolean isRtl(Context context) {
        if (UiUtilities.hasJellyBeanMR1()) {
            return context.getResources().getConfiguration().getLayoutDirection() == 1;
        }
        return false;
    }

    @TargetApi(value=17)
    public static boolean isViewLayoutRtl(View view) {
        if (UiUtilities.hasJellyBeanMR1()) {
            return view.getLayoutDirection() == 1;
        }
        return false;
    }

    public static void setStartPadding(Context context, View view, int padding) {
        if (UiUtilities.isRtl(context)) {
            view.setPadding(view.getPaddingLeft(), view.getPaddingTop(), padding, view.getPaddingBottom());
        } else {
            view.setPadding(padding, view.getPaddingTop(), view.getPaddingRight(), view.getPaddingBottom());
        }
    }
}

