/*
 * Decompiled with CFR 0.152.
 */
package com.laputapp.utilities;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.os.Bundle;
import android.util.Patterns;
import com.laputapp.utilities.Strings;

public final class Utilities {
    public static String getMetaData(Context context, String key) {
        Bundle metaData = null;
        String value = null;
        if (context == null || key == null) {
            return null;
        }
        try {
            ApplicationInfo ai = context.getPackageManager().getApplicationInfo(context.getPackageName(), 128);
            if (null != ai) {
                metaData = ai.metaData;
            }
            if (null != metaData) {
                value = metaData.getString(key);
            }
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            // empty catch block
        }
        return value;
    }

    public static boolean isEmailValid(String email) {
        if (Strings.isBlank(email)) {
            return false;
        }
        return Patterns.EMAIL_ADDRESS.matcher(email).matches();
    }

    public static boolean isMobileValid(String mobile) {
        if (Strings.isBlank(mobile)) {
            return false;
        }
        return Patterns.PHONE.matcher(mobile).matches();
    }
}

