/*
 * Decompiled with CFR 0.152.
 */
package com.laputapp.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.util.Log;
import android.util.SparseArray;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AbsListView;
import android.widget.BaseAdapter;
import android.widget.LinearLayout;
import android.widget.ListAdapter;
import android.widget.ListView;
import com.laputapp.R;
import com.laputapp.ui.ListFragment;
import com.laputapp.utilities.Lists;
import com.laputapp.widget.CollectionViewCallbacks;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;

public class CollectionView
extends ListView {
    private static final String TAG = "CollectionView";
    private static final int BUILTIN_VIEWTYPE_HEADER = 0;
    private static final int BUILTIN_VIEWTYPE_COUNT = 1;
    private Inventory mInventory = new Inventory();
    private CollectionViewCallbacks mCallbacks = null;
    private int mContentTopClearance = 0;
    private int mInternalPadding;
    private MultiScrollListener mMultiScrollListener;
    private ListFragment mListFragment;
    RowComputeResult mRowComputeResult = new RowComputeResult();

    public CollectionView(Context context) {
        this(context, null);
    }

    public CollectionView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public CollectionView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.setDivider(null);
        this.setDividerHeight(0);
        this.setItemsCanFocus(false);
        this.setChoiceMode(0);
        this.setSelector(17170445);
        if (attrs != null) {
            TypedArray xmlArgs = context.obtainStyledAttributes(attrs, R.styleable.CollectionView, defStyle, 0);
            this.mInternalPadding = xmlArgs.getDimensionPixelSize(R.styleable.CollectionView_internalPadding, 0);
            this.mContentTopClearance = xmlArgs.getDimensionPixelSize(R.styleable.CollectionView_contentTopClearance, 0);
        }
    }

    public void updateInventory(ListFragment fragment, Inventory inv) {
        this.updateInventory(fragment, inv, true);
    }

    public void updateInventory(ListFragment fragment, Inventory inv, boolean animate) {
        this.mListFragment = fragment;
        if (animate) {
            Log.d((String)TAG, (String)"CollectionView updating inventory with animation.");
            this.setAlpha(0.0f);
            this.updateInventoryImmediate(inv, animate);
            this.doFadeInAnimation();
        } else {
            Log.d((String)TAG, (String)"CollectionView updating inventory without animation.");
            this.updateInventoryImmediate(inv, animate);
        }
    }

    private void updateInventoryImmediate(Inventory inv, boolean animate) {
        this.mInventory = new Inventory(inv);
        this.notifyAdapterDataSetChanged();
        if (animate) {
            this.startLayoutAnimation();
        }
    }

    private void doFadeInAnimation() {
        this.setAlpha(0.0f);
        this.animate().setDuration(250L).alpha(1.0f);
    }

    public void setCollectionAdapter(CollectionViewCallbacks adapter) {
        this.mCallbacks = adapter;
    }

    private void notifyAdapterDataSetChanged() {
        this.mListFragment.setListAdapter((ListAdapter)new MyListAdapter());
    }

    public void setContentTopClearance(int clearance) {
        if (this.mContentTopClearance != clearance) {
            this.mContentTopClearance = clearance;
            this.setPadding(this.getPaddingLeft(), this.mContentTopClearance, this.getPaddingRight(), this.getPaddingBottom());
            this.notifyAdapterDataSetChanged();
        }
    }

    private boolean computeRowContent(int row, RowComputeResult result) {
        int curRow = 0;
        int posInGroup = 0;
        for (InventoryGroup group : this.mInventory.mGroups) {
            if (group.mShowHeader) {
                if (curRow == row) {
                    result.row = row;
                    result.isHeader = true;
                    result.groupId = group.mGroupId;
                    result.group = group;
                    result.groupOffset = -1;
                    return true;
                }
                ++curRow;
            }
            posInGroup = 0;
            while (posInGroup < group.mItemCount) {
                if (curRow == row) {
                    result.row = row;
                    result.isHeader = false;
                    result.groupId = group.mGroupId;
                    result.group = group;
                    result.groupOffset = posInGroup;
                    return true;
                }
                posInGroup += group.mDisplayCols;
                ++curRow;
            }
        }
        return false;
    }

    private View getRowView(int row, View convertView, ViewGroup parent) {
        if (this.computeRowContent(row, this.mRowComputeResult)) {
            return this.makeRow(convertView, this.mRowComputeResult, parent);
        }
        Log.e((String)TAG, (String)("Invalid row passed to getView: " + row));
        return convertView != null ? convertView : new View(this.getContext());
    }

    private int getRowViewType(int row) {
        if (this.computeRowContent(row, this.mRowComputeResult)) {
            int type = this.mRowComputeResult.isHeader ? 0 : 1 + this.mInventory.getGroupIndex(this.mRowComputeResult.groupId);
            return type;
        }
        Log.e((String)TAG, (String)("Invalid row passed to getItemViewType: " + row));
        return 0;
    }

    public void setOnScrollListener(AbsListView.OnScrollListener listener) {
        if (this.mMultiScrollListener == null) {
            this.mMultiScrollListener = new MultiScrollListener();
            super.setOnScrollListener((AbsListView.OnScrollListener)this.mMultiScrollListener);
        }
        this.mMultiScrollListener.addOnScrollListener(listener);
    }

    private View makeRow(View view, RowComputeResult rowInfo, ViewGroup parent) {
        String actualViewType;
        if (this.mCallbacks == null) {
            Log.e((String)TAG, (String)"Call to makeRow without an adapter installed");
            return view != null ? view : new View(this.getContext());
        }
        String desiredViewType = this.mInventory.hashCode() + "." + this.getRowViewType(rowInfo.row);
        String string2 = actualViewType = view != null && view.getTag() != null ? view.getTag().toString() : "";
        if (!desiredViewType.equals(actualViewType)) {
            view = null;
        }
        if (rowInfo.isHeader) {
            if (view == null) {
                view = this.mCallbacks.newCollectionHeaderView(this.getContext(), parent);
            }
            this.mCallbacks.bindCollectionHeaderView(this.getContext(), view, rowInfo.groupId, rowInfo.group.mHeaderLabel);
        } else {
            view = this.makeItemRow(view, rowInfo);
        }
        view.setTag((Object)desiredViewType);
        return view;
    }

    private View makeItemRow(View convertView, RowComputeResult rowInfo) {
        return convertView == null ? this.makeNewItemRow(rowInfo) : this.recycleItemRow(convertView, rowInfo);
    }

    private View getItemView(RowComputeResult rowInfo, int column, View view, ViewGroup parent) {
        int indexInGroup = rowInfo.groupOffset + column;
        if (indexInGroup >= rowInfo.group.mItemCount) {
            if (view != null && view instanceof EmptyView) {
                return view;
            }
            view = new EmptyView(this.getContext());
            view.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -2));
            return view;
        }
        if (view == null || view instanceof EmptyView) {
            view = this.mCallbacks.newCollectionItemView(this.getContext(), rowInfo.groupId, parent);
        }
        this.mCallbacks.bindCollectionItemView(this.getContext(), view, rowInfo.groupId, indexInGroup, rowInfo.group.getDataIndex(indexInGroup), rowInfo.group.getItemTag(rowInfo.groupOffset + column));
        return view;
    }

    private LinearLayout.LayoutParams setupLayoutParams(View view) {
        LinearLayout.LayoutParams viewLayoutParams;
        if (view.getLayoutParams() instanceof LinearLayout.LayoutParams) {
            viewLayoutParams = (LinearLayout.LayoutParams)view.getLayoutParams();
        } else {
            Log.w((String)TAG, (String)("Unexpected class for collection view item's layout params: " + view.getLayoutParams().getClass().getName()));
            viewLayoutParams = new LinearLayout.LayoutParams(-1, -2);
        }
        viewLayoutParams.leftMargin = this.mInternalPadding / 2;
        viewLayoutParams.rightMargin = this.mInternalPadding / 2;
        viewLayoutParams.bottomMargin = this.mInternalPadding;
        viewLayoutParams.width = -1;
        viewLayoutParams.weight = 1.0f;
        view.setLayoutParams((ViewGroup.LayoutParams)viewLayoutParams);
        return viewLayoutParams;
    }

    private View makeNewItemRow(RowComputeResult rowInfo) {
        LinearLayout ll = new LinearLayout(this.getContext());
        AbsListView.LayoutParams params = new AbsListView.LayoutParams(-1, -2);
        ll.setOrientation(0);
        ll.setLayoutParams((ViewGroup.LayoutParams)params);
        for (int i = 0; i < rowInfo.group.mDisplayCols; ++i) {
            View view = this.getItemView(rowInfo, i, null, (ViewGroup)ll);
            LinearLayout.LayoutParams viewLayoutParams = this.setupLayoutParams(view);
            ll.addView(view, (ViewGroup.LayoutParams)viewLayoutParams);
        }
        return ll;
    }

    private View recycleItemRow(View convertView, RowComputeResult rowInfo) {
        LinearLayout ll = (LinearLayout)convertView;
        for (int i = 0; i < rowInfo.group.mDisplayCols; ++i) {
            View newView;
            View view = ll.getChildAt(i);
            if (view == (newView = this.getItemView(rowInfo, i, view, (ViewGroup)ll))) continue;
            LinearLayout.LayoutParams thisViewParams = this.setupLayoutParams(newView);
            ll.removeViewAt(i);
            ll.addView(newView, i, (ViewGroup.LayoutParams)thisViewParams);
        }
        return ll;
    }

    public static class InventoryGroup
    implements Cloneable {
        private int mGroupId = 0;
        private boolean mShowHeader = false;
        private String mHeaderLabel = "";
        private int mDataIndexStart = 0;
        private int mDisplayCols = 1;
        private int mItemCount = 0;
        private SparseArray<Object> mItemTag = new SparseArray();
        private SparseArray<Integer> mItemCustomDataIndices = new SparseArray();

        public InventoryGroup(int groupId) {
            this.mGroupId = groupId;
        }

        public InventoryGroup(InventoryGroup copyFrom) {
            this.mGroupId = copyFrom.mGroupId;
            this.mShowHeader = copyFrom.mShowHeader;
            this.mDataIndexStart = copyFrom.mDataIndexStart;
            this.mDisplayCols = copyFrom.mDisplayCols;
            this.mItemCount = copyFrom.mItemCount;
            this.mHeaderLabel = copyFrom.mHeaderLabel;
            this.mItemTag = Lists.cloneSparseArray(copyFrom.mItemTag);
            this.mItemCustomDataIndices = Lists.cloneSparseArray(copyFrom.mItemCustomDataIndices);
        }

        public InventoryGroup setShowHeader(boolean showHeader) {
            this.mShowHeader = showHeader;
            return this;
        }

        public InventoryGroup setHeaderLabel(String label) {
            this.mHeaderLabel = label;
            return this;
        }

        public String getHeaderLabel() {
            return this.mHeaderLabel;
        }

        public InventoryGroup setDataIndexStart(int dataIndexStart) {
            this.mDataIndexStart = dataIndexStart;
            return this;
        }

        public InventoryGroup setCustomDataIndex(int groupIndex, int customDataIndex) {
            this.mItemCustomDataIndices.put(groupIndex, (Object)customDataIndex);
            return this;
        }

        public int getDataIndex(int indexInGroup) {
            return (Integer)this.mItemCustomDataIndices.get(indexInGroup, (Object)(this.mDataIndexStart + indexInGroup));
        }

        public InventoryGroup setDisplayCols(int cols) {
            this.mDisplayCols = cols > 1 ? cols : 1;
            return this;
        }

        public InventoryGroup setItemCount(int count) {
            this.mItemCount = count;
            return this;
        }

        public InventoryGroup incrementItemCount() {
            ++this.mItemCount;
            return this;
        }

        public InventoryGroup setItemTag(int index, Object tag) {
            this.mItemTag.put(index, tag);
            return this;
        }

        public InventoryGroup addItemWithTag(Object tag) {
            ++this.mItemCount;
            this.setItemTag(this.mItemCount - 1, tag);
            return this;
        }

        public InventoryGroup addItemWithCustomDataIndex(int customDataIndex) {
            ++this.mItemCount;
            this.setCustomDataIndex(this.mItemCount - 1, customDataIndex);
            return this;
        }

        public int getRowCount() {
            return (this.mShowHeader ? 1 : 0) + this.mItemCount / this.mDisplayCols + (this.mItemCount % this.mDisplayCols > 0 ? 1 : 0);
        }

        public Object getItemTag(int i) {
            return this.mItemTag.get(i, null);
        }
    }

    private static class MultiScrollListener
    implements AbsListView.OnScrollListener {
        private final Set<AbsListView.OnScrollListener> children = new HashSet<AbsListView.OnScrollListener>();

        private MultiScrollListener() {
        }

        public void addOnScrollListener(AbsListView.OnScrollListener listener) {
            this.children.add(listener);
        }

        public void onScrollStateChanged(AbsListView absListView, int i) {
            for (AbsListView.OnScrollListener listener : this.children) {
                listener.onScrollStateChanged(absListView, i);
            }
        }

        public void onScroll(AbsListView absListView, int i, int i2, int i3) {
            for (AbsListView.OnScrollListener listener : this.children) {
                listener.onScroll(absListView, i, i2, i3);
            }
        }
    }

    public static class Inventory {
        private ArrayList<InventoryGroup> mGroups = new ArrayList();

        public Inventory() {
        }

        public Inventory(Inventory copyFrom) {
            for (InventoryGroup group : copyFrom.mGroups) {
                this.mGroups.add(group);
            }
        }

        public void addGroup(InventoryGroup group) {
            if (group.mItemCount > 0) {
                this.mGroups.add(new InventoryGroup(group));
            }
        }

        public int getTotalItemCount() {
            int total = 0;
            for (InventoryGroup group : this.mGroups) {
                total += group.mItemCount;
            }
            return total;
        }

        public int getGroupCount() {
            return this.mGroups.size();
        }

        public int getGroupIndex(int groupId) {
            for (int i = 0; i < this.mGroups.size(); ++i) {
                if (this.mGroups.get(i).mGroupId != groupId) continue;
                return i;
            }
            return -1;
        }
    }

    private static class EmptyView
    extends View {
        private EmptyView(Context ctx) {
            super(ctx);
        }
    }

    protected class MyListAdapter
    extends BaseAdapter {
        protected MyListAdapter() {
        }

        public int getCount() {
            int rowCount = 0;
            for (InventoryGroup group : CollectionView.this.mInventory.mGroups) {
                int thisGroupRowCount = group.getRowCount();
                rowCount += thisGroupRowCount;
            }
            return rowCount;
        }

        public Object getItem(int position) {
            return position;
        }

        public long getItemId(int position) {
            return position;
        }

        public View getView(int row, View convertView, ViewGroup parent) {
            return CollectionView.this.getRowView(row, convertView, parent);
        }

        public int getItemViewType(int row) {
            return CollectionView.this.getRowViewType(row);
        }

        public int getViewTypeCount() {
            return 1 + CollectionView.this.mInventory.mGroups.size();
        }
    }

    private class RowComputeResult {
        int row;
        boolean isHeader;
        int groupId;
        InventoryGroup group;
        int groupOffset;

        private RowComputeResult() {
        }
    }
}

