/*
 * Decompiled with CFR 0.152.
 */
package com.laputapp.widget;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.util.AttributeSet;
import android.widget.ImageView;
import com.laputapp.R;

public class ForegroundImageView
extends ImageView {
    private Drawable foreground;

    public ForegroundImageView(Context context) {
        this(context, null);
    }

    public ForegroundImageView(Context context, AttributeSet attrs) {
        super(context, attrs);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.ForegroundImageView);
        Drawable foreground = a.getDrawable(R.styleable.ForegroundImageView_android_foreground);
        if (foreground != null) {
            this.setForeground(foreground);
        }
        a.recycle();
    }

    public void setForegroundResource(int drawableResId) {
        this.setForeground(this.getContext().getResources().getDrawable(drawableResId));
    }

    public void setForeground(Drawable drawable) {
        if (this.foreground == drawable) {
            return;
        }
        if (this.foreground != null) {
            this.foreground.setCallback(null);
            this.unscheduleDrawable(this.foreground);
        }
        this.foreground = drawable;
        if (drawable != null) {
            drawable.setCallback((Drawable.Callback)this);
            if (drawable.isStateful()) {
                drawable.setState(this.getDrawableState());
            }
        }
        this.requestLayout();
        this.invalidate();
    }

    protected boolean verifyDrawable(Drawable who) {
        return super.verifyDrawable(who) || who == this.foreground;
    }

    public void jumpDrawablesToCurrentState() {
        super.jumpDrawablesToCurrentState();
        if (this.foreground != null) {
            this.foreground.jumpToCurrentState();
        }
    }

    protected void drawableStateChanged() {
        super.drawableStateChanged();
        if (this.foreground != null && this.foreground.isStateful()) {
            this.foreground.setState(this.getDrawableState());
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        if (this.foreground != null) {
            this.foreground.setBounds(0, 0, this.getMeasuredWidth(), this.getMeasuredHeight());
            this.invalidate();
        }
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        if (this.foreground != null) {
            this.foreground.setBounds(0, 0, w, h);
            this.invalidate();
        }
    }

    public void draw(Canvas canvas) {
        super.draw(canvas);
        if (this.foreground != null) {
            this.foreground.draw(canvas);
        }
    }

    @TargetApi(value=21)
    public void drawableHotspotChanged(float x, float y) {
        super.drawableHotspotChanged(x, y);
        if (Build.VERSION.SDK_INT >= 21 && this.foreground != null) {
            this.foreground.setHotspot(x, y);
        }
    }
}

