/*
 * Decompiled with CFR 0.152.
 */
package com.laputapp.widget;

import android.app.Dialog;
import android.content.Context;
import android.text.TextUtils;
import android.view.View;
import android.view.Window;
import android.widget.ProgressBar;
import android.widget.TextView;
import com.laputapp.R;
import com.laputapp.utilities.UiUtilities;

public class ProgressLoading
extends Dialog {
    private ProgressBar mProgressBar;
    private TextView mMessageTextView;
    private Window mWindow;
    private CharSequence mMessage;
    private boolean mShowProgress = true;

    public ProgressLoading(Context context, int theme) {
        super(context, theme);
        this.initialize(context, theme);
    }

    private void initialize(Context context, int theme) {
        this.mWindow = this.getWindow();
        this.mWindow.requestFeature(1);
        this.setContentView(R.layout.progress_loading);
        this.mMessageTextView = (TextView)this.findViewById(R.id.text_message);
        this.mProgressBar = (ProgressBar)this.findViewById(R.id.progress);
    }

    public ProgressLoading setMessage(int resId) {
        return this.setMessage(this.getContext().getString(resId));
    }

    public ProgressLoading setMessage(CharSequence msg) {
        this.mMessage = msg;
        return this;
    }

    public ProgressLoading updateMessage(CharSequence msg) {
        this.mMessage = msg;
        this.show();
        return this;
    }

    public ProgressLoading hideMessage() {
        return this.updateMessage("");
    }

    public ProgressLoading hideProgressBar() {
        this.mShowProgress = false;
        this.show();
        return this;
    }

    public void show() {
        if (TextUtils.isEmpty((CharSequence)this.mMessage)) {
            UiUtilities.setVisibilitySafe((View)this.mMessageTextView, 8);
        } else {
            UiUtilities.setVisibilitySafe((View)this.mMessageTextView, 0);
            this.mMessageTextView.setText(this.mMessage);
        }
        if (this.mShowProgress) {
            UiUtilities.setVisibilitySafe((View)this.mProgressBar, 0);
        } else {
            UiUtilities.setVisibilitySafe((View)this.mProgressBar, 8);
        }
        super.show();
    }
}

