/*
 * Decompiled with CFR 0.152.
 */
package com.laputapp.widget;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.ListView;
import android.widget.TextView;
import com.laputapp.R;

public class ResourceLoadingIndicator {
    private ListView mListView;
    private boolean showing;
    private final View view;
    private final TextView textView;

    public ResourceLoadingIndicator(Context context) {
        this(context, 0);
    }

    public ResourceLoadingIndicator(Context context, int loadingResId) {
        this.view = LayoutInflater.from((Context)context).inflate(R.layout.loading_indicator, null);
        this.textView = (TextView)this.view.findViewById(R.id.text_loading);
        if (loadingResId > 0) {
            this.textView.setVisibility(0);
            this.textView.setText(loadingResId);
        } else {
            this.textView.setVisibility(8);
        }
    }

    public ResourceLoadingIndicator setList(ListView listView) {
        this.mListView = listView;
        this.showing = false;
        return this;
    }

    public ResourceLoadingIndicator setVisible(boolean visible) {
        if (this.showing != visible && this.mListView != null) {
            if (visible) {
                this.mListView.addFooterView(this.view);
            } else {
                this.mListView.removeFooterView(this.view);
            }
        }
        this.showing = visible;
        return this;
    }
}

