/*
 * Decompiled with CFR 0.152.
 */
package com.laputapp.widget;

import android.content.Context;
import android.content.res.ColorStateList;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.ShapeDrawable;
import android.graphics.drawable.shapes.RoundRectShape;
import android.graphics.drawable.shapes.Shape;
import android.os.Build;
import android.support.v4.graphics.ColorUtils;
import android.support.v7.widget.AppCompatButton;
import android.util.AttributeSet;
import android.view.View;
import com.laputapp.R;
import com.laputapp.utilities.ThemeUtils;
import com.laputapp.utilities.ViewCompat;

public class RoundedButton
extends AppCompatButton {
    public RoundedButton(Context context) {
        this(context, null);
    }

    public RoundedButton(Context context, AttributeSet attrs) {
        this(context, attrs, R.attr.buttonStyle);
    }

    public RoundedButton(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        if (Build.VERSION.SDK_INT >= 21) {
            this.setBackgroundResource(R.drawable.btn_default);
        } else {
            ViewCompat.setBackground((View)this, this.createButtonBackground(context));
            ViewCompat.setBackgroundTintList((View)this, (ColorStateList)this.createButtonColorStateList(context));
        }
    }

    protected Drawable createButtonBackground(Context context) {
        float buttonCornerRadius = ThemeUtils.getThemeAttrDimension(context, R.attr.buttonCornerRadius);
        float[] outerRadii = new float[8];
        for (int i = 0; i < outerRadii.length; ++i) {
            outerRadii[i] = buttonCornerRadius;
        }
        return new ShapeDrawable((Shape)new RoundRectShape(outerRadii, null, null));
    }

    protected ColorStateList createButtonColorStateList(Context context) {
        int[][] states = new int[4][];
        int[] colors = new int[4];
        int i = 0;
        int colorButtonDisabled = ThemeUtils.getThemeAttrColor((Context)context, (int)R.attr.colorButtonDisabled);
        int colorButtonNormal = ThemeUtils.getThemeAttrColor((Context)context, (int)R.attr.colorButtonNormal);
        int colorControlHighlight = ThemeUtils.getThemeAttrColor((Context)context, (int)R.attr.colorControlHighlight);
        states[i] = new int[]{-16842910};
        colors[i] = colorButtonDisabled != 0 ? colorButtonDisabled : ThemeUtils.getDisabledThemeAttrColor((Context)context, (int)R.attr.colorButtonNormal);
        states[++i] = new int[]{16842919};
        colors[i] = ColorUtils.compositeColors((int)colorControlHighlight, (int)colorButtonNormal);
        states[++i] = new int[]{16842908};
        colors[i] = ColorUtils.compositeColors((int)colorControlHighlight, (int)colorButtonNormal);
        states[++i] = new int[0];
        colors[i] = colorButtonNormal;
        return new ColorStateList((int[][])states, colors);
    }
}

