/*
 * Decompiled with CFR 0.152.
 */
package com.loopj.android.http;

import com.loopj.android.http.AsyncHttpResponseHandler;
import com.loopj.android.http.BinaryHttpResponseHandler;
import java.io.IOException;
import java.net.ConnectException;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.AbstractHttpClient;
import org.apache.http.protocol.HttpContext;

class AsyncHttpRequest
implements Runnable {
    private final AbstractHttpClient client;
    private final HttpContext context;
    private final HttpUriRequest request;
    private final AsyncHttpResponseHandler responseHandler;
    private boolean isBinaryRequest;
    private int executionCount;

    public AsyncHttpRequest(AbstractHttpClient client, HttpContext context, HttpUriRequest request, AsyncHttpResponseHandler responseHandler) {
        this.client = client;
        this.context = context;
        this.request = request;
        this.responseHandler = responseHandler;
        if (responseHandler instanceof BinaryHttpResponseHandler) {
            this.isBinaryRequest = true;
        }
    }

    @Override
    public void run() {
        block5: {
            try {
                if (this.responseHandler != null) {
                    this.responseHandler.sendStartMessage();
                }
                this.makeRequestWithRetries();
                if (this.responseHandler != null) {
                    this.responseHandler.sendFinishMessage();
                }
            }
            catch (IOException e) {
                if (this.responseHandler == null) break block5;
                this.responseHandler.sendFinishMessage();
                if (this.isBinaryRequest) {
                    this.responseHandler.sendFailureMessage((Throwable)e, (byte[])null);
                }
                this.responseHandler.sendFailureMessage((Throwable)e, (String)null);
            }
        }
    }

    private void makeRequest() throws IOException {
        if (!Thread.currentThread().isInterrupted()) {
            HttpResponse response = this.client.execute(this.request, this.context);
            if (!Thread.currentThread().isInterrupted() && this.responseHandler != null) {
                this.responseHandler.sendResponseMessage(response);
            }
        }
    }

    private void makeRequestWithRetries() throws ConnectException {
        boolean retry = true;
        IOException cause = null;
        HttpRequestRetryHandler retryHandler = this.client.getHttpRequestRetryHandler();
        while (retry) {
            try {
                this.makeRequest();
                return;
            }
            catch (UnknownHostException e) {
                if (this.responseHandler != null) {
                    this.responseHandler.sendFailureMessage((Throwable)e, "can't resolve host");
                }
                return;
            }
            catch (SocketException e) {
                if (this.responseHandler != null) {
                    this.responseHandler.sendFailureMessage((Throwable)e, "can't resolve host");
                }
                return;
            }
            catch (SocketTimeoutException e) {
                if (this.responseHandler != null) {
                    this.responseHandler.sendFailureMessage((Throwable)e, "socket time out");
                }
                return;
            }
            catch (IOException e) {
                cause = e;
                retry = retryHandler.retryRequest(cause, ++this.executionCount, this.context);
            }
            catch (NullPointerException e) {
                cause = new IOException("NPE in HttpClient" + e.getMessage());
                retry = retryHandler.retryRequest(cause, ++this.executionCount, this.context);
            }
        }
        ConnectException ex = new ConnectException();
        ex.initCause(cause);
        throw ex;
    }
}

