/*
 * Decompiled with CFR 0.152.
 */
package com.lordofthejars.nosqlunit.couchbase;

import com.couchbase.client.CouchbaseClient;
import com.couchbase.client.protocol.views.AbstractView;
import com.couchbase.client.protocol.views.DesignDocument;
import com.couchbase.client.protocol.views.InvalidViewException;
import com.couchbase.client.protocol.views.Query;
import com.couchbase.client.protocol.views.Stale;
import com.couchbase.client.protocol.views.View;
import com.couchbase.client.protocol.views.ViewDesign;
import com.couchbase.client.protocol.views.ViewResponse;
import com.couchbase.client.protocol.views.ViewRow;
import com.lordofthejars.nosqlunit.core.FailureHandler;
import com.lordofthejars.nosqlunit.couchbase.DataLoader;
import com.lordofthejars.nosqlunit.couchbase.model.Document;
import com.lordofthejars.nosqlunit.util.DeepEquals;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.codehaus.jackson.JsonGenerationException;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.JsonProcessingException;
import org.codehaus.jackson.map.JsonMappingException;
import org.codehaus.jackson.map.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CouchbaseAssertion {
    private static final Logger LOGGER = LoggerFactory.getLogger(CouchbaseAssertion.class);
    private static final String DESIGN_DOC_INTERNAL = "__design_doc_internal_";
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    public static void strictAssertEquals(InputStream dataset, CouchbaseClient couchbaseClient) {
        Map<String, Document> expectedDocuments = DataLoader.getDocuments(dataset);
        List<String> allDocumentIds = CouchbaseAssertion.getAllDocumentIds(couchbaseClient);
        CouchbaseAssertion.checkNumberOfDocuments(expectedDocuments, allDocumentIds);
        CouchbaseAssertion.checkEachDocument(expectedDocuments, allDocumentIds, couchbaseClient);
    }

    private static void checkEachDocument(Map<String, Document> expectedDocuments, List<String> allDocumentIds, CouchbaseClient couchbaseClient) {
        for (String id : allDocumentIds) {
            String expected;
            Object real = couchbaseClient.get(id);
            if (DeepEquals.deepEquals((Object)real, (Object)(expected = CouchbaseAssertion.toJson(expectedDocuments.get(id).getDocument())))) continue;
            throw FailureHandler.createFailure((String)"Expected element # %s # is not found but # %s # was found.", (Object[])new Object[]{CouchbaseAssertion.toJson(expected), CouchbaseAssertion.toJson(real)});
        }
    }

    private static String toJson(Object document) {
        try {
            return OBJECT_MAPPER.writeValueAsString(document);
        }
        catch (JsonGenerationException e) {
            throw new IllegalArgumentException(e);
        }
        catch (JsonMappingException e) {
            throw new IllegalArgumentException(e);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private static Object fromJson(Object document) {
        if (document instanceof String) {
            String json = (String)document;
            try {
                JsonNode node = OBJECT_MAPPER.readTree(json);
                return OBJECT_MAPPER.readValue(json, String.class);
            }
            catch (JsonProcessingException e) {
                throw new IllegalArgumentException(e);
            }
            catch (IOException e) {
                throw new IllegalArgumentException(e);
            }
        }
        return document;
    }

    private static void checkNumberOfDocuments(Map<String, Document> expectedDocuments, List<String> allDocumentIds) {
        int currentSize;
        int expectedSize = expectedDocuments.size();
        if (expectedSize != (currentSize = allDocumentIds.size())) {
            throw FailureHandler.createFailure((String)"Expected number of elements are %s but insert are %s. DB document IDS: %s", (Object[])new Object[]{expectedSize, currentSize, allDocumentIds});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<String> getAllDocumentIds(CouchbaseClient couchbaseClient) {
        String freeDesignDocName = CouchbaseAssertion.nextUniqueViewName(couchbaseClient);
        try {
            List<String> result;
            View allDocsView = CouchbaseAssertion.createDesignDocAndView(freeDesignDocName, couchbaseClient);
            List<String> list = result = CouchbaseAssertion.getAllDocumentIds(allDocsView, couchbaseClient);
            return list;
        }
        finally {
            CouchbaseAssertion.deleteDesignDoc(freeDesignDocName, couchbaseClient);
        }
    }

    private static List<String> getAllDocumentIds(View allDocsView, CouchbaseClient couchbaseClient) {
        Query query = new Query();
        query.setStale(Stale.FALSE);
        ViewResponse viewResults = couchbaseClient.query((AbstractView)allDocsView, query);
        ArrayList<String> result = new ArrayList<String>();
        for (ViewRow viewResult : viewResults) {
            result.add(viewResult.getId());
        }
        return result;
    }

    private static View createDesignDocAndView(String freeDesignDocName, CouchbaseClient couchbaseClient) {
        DesignDocument designDocument = new DesignDocument(freeDesignDocName);
        String json = "function (doc, meta) {\n   emit(null, null);\n}";
        String viewName = "allDocs";
        designDocument.getViews().add(new ViewDesign("allDocs", "function (doc, meta) {\n   emit(null, null);\n}"));
        Boolean designDoc = couchbaseClient.createDesignDoc(designDocument);
        if (!designDoc.booleanValue()) {
            throw new IllegalStateException("Cannot create internal designDoc to query for all docs. Name of DesignDoc: " + freeDesignDocName);
        }
        return couchbaseClient.getView(freeDesignDocName, "allDocs");
    }

    private static void deleteDesignDoc(String freeDesignDocName, CouchbaseClient couchbaseClient) {
        couchbaseClient.deleteDesignDoc(freeDesignDocName);
    }

    private static String nextUniqueViewName(CouchbaseClient couchbaseClient) {
        int i = 0;
        while (true) {
            String proposal = DESIGN_DOC_INTERNAL + i++;
            try {
                couchbaseClient.getDesignDoc(proposal);
                LOGGER.trace("Invalid doc, keep trying. Now trying with {} " + proposal);
            }
            catch (InvalidViewException ignored) {
                return proposal;
            }
        }
    }
}

