/*
 * Decompiled with CFR 0.152.
 */
package com.lordofthejars.nosqlunit.couchbase;

import com.couchbase.client.CouchbaseClient;
import com.lordofthejars.nosqlunit.core.AbstractCustomizableDatabaseOperation;
import com.lordofthejars.nosqlunit.core.NoSqlAssertionError;
import com.lordofthejars.nosqlunit.couchbase.CouchBaseClientCallback;
import com.lordofthejars.nosqlunit.couchbase.DefaultCouchbaseComparisonStrategy;
import com.lordofthejars.nosqlunit.couchbase.DefaultCouchbaseInsertionStrategy;
import java.io.InputStream;

public class CouchbaseOperation
extends AbstractCustomizableDatabaseOperation<CouchBaseClientCallback, CouchbaseClient> {
    private final CouchbaseClient couchbaseClient;

    public CouchbaseOperation(CouchbaseClient client) {
        this.couchbaseClient = client;
        this.setInsertionStrategy(new DefaultCouchbaseInsertionStrategy());
        this.setComparisonStrategy(new DefaultCouchbaseComparisonStrategy());
    }

    public void insert(InputStream dataScript) {
        this.insertData(dataScript);
    }

    private void insertData(InputStream dataScript) {
        try {
            this.executeInsertion(new CouchBaseClientCallback(){

                @Override
                public CouchbaseClient couchBaseClient() {
                    return CouchbaseOperation.this.couchbaseClient;
                }
            }, dataScript);
        }
        catch (Throwable e) {
            throw new IllegalStateException(e);
        }
    }

    public void deleteAll() {
        this.removeDatabase();
    }

    private void removeDatabase() {
        this.couchbaseClient.flush();
    }

    public boolean databaseIs(InputStream expectedData) {
        return this.compareData(expectedData);
    }

    private boolean compareData(InputStream expectedData) throws NoSqlAssertionError {
        try {
            return this.executeComparison(new CouchBaseClientCallback(){

                @Override
                public CouchbaseClient couchBaseClient() {
                    return CouchbaseOperation.this.couchbaseClient;
                }
            }, expectedData);
        }
        catch (NoSqlAssertionError e) {
            throw e;
        }
        catch (Throwable e) {
            throw new IllegalStateException(e);
        }
    }

    public CouchbaseClient connectionManager() {
        return this.couchbaseClient;
    }
}

