/*
 * Decompiled with CFR 0.152.
 */
package com.lordofthejars.nosqlunit.couchbase;

import com.couchbase.client.CouchbaseClient;
import com.lordofthejars.nosqlunit.core.AbstractNoSqlTestRule;
import com.lordofthejars.nosqlunit.core.DatabaseOperation;
import com.lordofthejars.nosqlunit.couchbase.CouchbaseConfiguration;
import com.lordofthejars.nosqlunit.couchbase.CouchbaseOperation;
import com.lordofthejars.nosqlunit.couchbase.RemoteCouchbaseConfigurationBuilder;

public class CouchbaseRule
extends AbstractNoSqlTestRule {
    private static final String EXTENSION = "json";
    private DatabaseOperation<CouchbaseClient> databaseOperation;

    public CouchbaseRule(CouchbaseConfiguration configuration) {
        super(configuration.getConnectionIdentifier());
        this.databaseOperation = new CouchbaseOperation(configuration.getClient());
    }

    public CouchbaseRule(CouchbaseConfiguration configuration, Object target) {
        super(configuration.getConnectionIdentifier());
        this.setTarget(target);
        this.databaseOperation = new CouchbaseOperation(configuration.getClient());
    }

    public DatabaseOperation getDatabaseOperation() {
        return this.databaseOperation;
    }

    public String getWorkingExtension() {
        return EXTENSION;
    }

    public static CouchbaseRule defaultRemoteCouchbase(String bucketName) {
        CouchbaseConfiguration configuration = RemoteCouchbaseConfigurationBuilder.Builder.start().bucketName(bucketName).build();
        return new CouchbaseRule(configuration);
    }
}

