/*
 * Decompiled with CFR 0.152.
 */
package com.lordofthejars.nosqlunit.couchbase;

import com.couchbase.client.CouchbaseClient;
import com.lordofthejars.nosqlunit.couchbase.model.Document;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import org.codehaus.jackson.JsonGenerationException;
import org.codehaus.jackson.JsonParseException;
import org.codehaus.jackson.map.JsonMappingException;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.type.MapType;
import org.codehaus.jackson.map.type.TypeFactory;
import org.codehaus.jackson.type.JavaType;

public class DataLoader {
    private static final ObjectMapper MAPPER = new ObjectMapper();
    public static final String DATA_ROOT = "data";
    public static final String DESIGN_ROOT = "designDocs";
    private CouchbaseClient couchbaseClient;

    public DataLoader(CouchbaseClient couchbaseClient) {
        this.couchbaseClient = couchbaseClient;
    }

    public void load(InputStream dataScript) {
        Map<String, Document> documentsIterator = DataLoader.getDocuments(dataScript);
        this.insertDocuments(documentsIterator);
    }

    private void insertDocuments(Map<String, Document> documentsIterator) {
        for (Map.Entry<String, Document> documentEntry : documentsIterator.entrySet()) {
            Document document = documentEntry.getValue();
            try {
                this.couchbaseClient.add(documentEntry.getKey(), document.calculateExpiration(), (Object)MAPPER.writeValueAsString(document.getDocument())).get();
            }
            catch (JsonGenerationException e) {
                throw new IllegalArgumentException(e);
            }
            catch (JsonMappingException e) {
                throw new IllegalArgumentException(e);
            }
            catch (InterruptedException e) {
                throw new IllegalArgumentException(e);
            }
            catch (ExecutionException e) {
                throw new IllegalArgumentException(e);
            }
            catch (IOException e) {
                throw new IllegalArgumentException(e);
            }
        }
    }

    public static Map<String, Document> getDocuments(InputStream dataScript) {
        Map rootNode;
        TypeFactory typeFactory = MAPPER.getTypeFactory();
        MapType mapType = typeFactory.constructMapType(Map.class, String.class, Document.class);
        JavaType stringType = typeFactory.uncheckedSimpleType(String.class);
        MapType type = typeFactory.constructMapType(Map.class, stringType, (JavaType)mapType);
        try {
            rootNode = (Map)MAPPER.readValue(dataScript, (JavaType)type);
        }
        catch (JsonParseException e) {
            throw new IllegalArgumentException(e);
        }
        catch (JsonMappingException e) {
            throw new IllegalArgumentException(e);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
        return (Map)rootNode.get(DATA_ROOT);
    }
}

