/*
 * Decompiled with CFR 0.152.
 */
package com.lordofthejars.nosqlunit.couchbase;

import com.lordofthejars.nosqlunit.couchbase.CouchbaseConfiguration;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;

public class RemoteCouchbaseConfigurationBuilder {

    public static class Builder {
        private String name;
        private String password = "";
        private List<URI> uris = new ArrayList<URI>();

        private Builder() {
        }

        public static Builder start() {
            return new Builder();
        }

        public Builder bucketName(String name) {
            this.name = name;
            return this;
        }

        public Builder bucketPassword(String pass) {
            this.password = pass;
            return this;
        }

        public Builder serverUri(String url) {
            this.uris.add(URI.create(url));
            return this;
        }

        public CouchbaseConfiguration build() {
            if (this.uris.isEmpty()) {
                this.uris.add(URI.create("http://localhost:8091/pools"));
            }
            return new CouchbaseConfiguration(this.uris, this.password, this.name);
        }
    }
}

