/*
 * Decompiled with CFR 0.152.
 */
package com.lordofthejars.nosqlunit.demo.couchbase;

import com.couchbase.client.CouchbaseClient;
import com.lordofthejars.nosqlunit.demo.model.Book;
import java.io.IOException;
import java.text.Normalizer;
import java.util.Locale;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.regex.Pattern;
import net.spy.memcached.internal.OperationCompletionListener;
import net.spy.memcached.internal.OperationFuture;
import org.codehaus.jackson.JsonParseException;
import org.codehaus.jackson.map.JsonMappingException;
import org.codehaus.jackson.map.ObjectMapper;

public class BookManager {
    public static final ObjectMapper mapper = new ObjectMapper();
    private static final Pattern NON_LATIN = Pattern.compile("[^\\w-]");
    private static final Pattern WHITESPACE = Pattern.compile("[\\s]");
    private CouchbaseClient client;

    public BookManager(CouchbaseClient client) {
        this.client = client;
    }

    public OperationFuture<Boolean> create(final Book book) throws ExecutionException, InterruptedException {
        final String key = this.nextKey();
        String value = this.toTitleKey(book.getTitle());
        OperationFuture future = this.client.set(value, (Object)key);
        return future.addListener(new OperationCompletionListener(){

            public void onComplete(OperationFuture<?> operationFuture) throws Exception {
                BookManager.this.client.set(key, (Object)mapper.writeValueAsBytes((Object)book));
            }
        });
    }

    public Book findBookByTitle(String title) throws JsonParseException, JsonMappingException, IOException {
        String key = ((String)this.client.get(this.toTitleKey(title))).replaceAll("\"", "");
        if (key == null) {
            throw new IllegalStateException("Cannot find the key object for the campaign with title: " + title);
        }
        String json = (String)this.client.get(key);
        return (Book)mapper.readValue(json, Book.class);
    }

    public Book findById(Long id) throws JsonParseException, JsonMappingException, IOException {
        String json = (String)this.client.get(this.toIdKey(String.valueOf(id)));
        return (Book)mapper.readValue(json, Book.class);
    }

    private String toTitleKey(String title) {
        return "T::" + BookManager.toSlug(title);
    }

    private String nextKey() {
        return this.toIdKey(UUID.randomUUID().toString());
    }

    private String toIdKey(String id) {
        return "K::" + id;
    }

    public static String toSlug(String input) {
        String nonwhites = WHITESPACE.matcher(input).replaceAll("-");
        String normalized = Normalizer.normalize(nonwhites, Normalizer.Form.NFD);
        String slug = NON_LATIN.matcher(normalized).replaceAll("");
        return slug.toLowerCase(Locale.ENGLISH);
    }
}

