/*
 * Decompiled with CFR 0.152.
 */
package com.lordofthejars.nosqlunit.demo.elasticsearch;

import com.lordofthejars.nosqlunit.demo.custom.MapBookConverter;
import com.lordofthejars.nosqlunit.demo.model.Book;
import java.util.ArrayList;
import java.util.List;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.action.index.IndexRequestBuilder;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.search.SearchHit;

public class BookManager {
    private Client client;

    public BookManager(Client client) {
        this.client = client;
    }

    public void create(Book book) {
        IndexRequestBuilder indexRequestBuilder = this.client.prepareIndex("books", "book", null).setSource(MapBookConverter.toMap(book));
        indexRequestBuilder.execute().actionGet();
    }

    public Book findBookById(String id) {
        GetResponse actionGet = (GetResponse)this.client.prepareGet("books", "book", id).execute().actionGet();
        return MapBookConverter.toBook(actionGet.getSource());
    }

    public List<Book> searchAllBooks() {
        ArrayList<Book> books = new ArrayList<Book>();
        SearchResponse response = (SearchResponse)this.client.prepareSearch(new String[0]).execute().actionGet();
        for (SearchHit hit : response.getHits()) {
            books.add(MapBookConverter.toBook(hit.getSource()));
        }
        return books;
    }
}

