/*
 * Decompiled with CFR 0.152.
 */
package com.lordofthejars.nosqlunit.demo.mongodb;

import com.lordofthejars.nosqlunit.demo.model.Book;
import com.lordofthejars.nosqlunit.demo.mongodb.DbObjectBookConverter;
import com.lordofthejars.nosqlunit.demo.mongodb.MongoDbBookConverter;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BookManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(BookManager.class);
    private static final MongoDbBookConverter MONGO_DB_BOOK_CONVERTER = new MongoDbBookConverter();
    private static final DbObjectBookConverter DB_OBJECT_BOOK_CONVERTER = new DbObjectBookConverter();
    private DBCollection booksCollection;

    public BookManager(DBCollection booksCollection) {
        this.booksCollection = booksCollection;
    }

    public void create(Book book) {
        DBObject dbObject = MONGO_DB_BOOK_CONVERTER.convert(book);
        this.booksCollection.insert(new DBObject[]{dbObject});
    }

    public List<Book> findAll() {
        LOGGER.debug("Finding All Elements of Collection " + this.booksCollection.getName());
        ArrayList<Book> books = new ArrayList<Book>();
        DBCursor findAll = this.booksCollection.find();
        while (findAll.hasNext()) {
            books.add(DB_OBJECT_BOOK_CONVERTER.convert(findAll.next()));
        }
        return books;
    }
}

