/*
 * Decompiled with CFR 0.152.
 */
package com.lordofthejars.nosqlunit.demo.neo4j;

import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.ReturnableEvaluator;
import org.neo4j.graphdb.StopEvaluator;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.Traverser;

public class MatrixManager {
    private GraphDatabaseService graphDb;

    public MatrixManager(GraphDatabaseService graphDatabaseService) {
        this.graphDb = graphDatabaseService;
    }

    public int countNeoFriends() {
        Node neoNode = this.getNeoNode();
        Traverser friendsTraverser = this.getFriends(neoNode);
        return friendsTraverser.getAllNodes().size();
    }

    public void addNeoFriend(String name, int age) {
        Transaction tx = this.graphDb.beginTx();
        try {
            Node friend = this.graphDb.createNode();
            friend.setProperty("name", (Object)name);
            Relationship relationship = this.getNeoNode().createRelationshipTo(friend, (RelationshipType)RelTypes.KNOWS);
            relationship.setProperty("age", (Object)age);
            tx.success();
        }
        finally {
            tx.finish();
        }
    }

    private Traverser getFriends(Node person) {
        return person.traverse(Traverser.Order.BREADTH_FIRST, StopEvaluator.END_OF_GRAPH, ReturnableEvaluator.ALL_BUT_START_NODE, (RelationshipType)RelTypes.KNOWS, Direction.OUTGOING);
    }

    public Node getNeoNode() {
        return this.graphDb.getReferenceNode().getSingleRelationship((RelationshipType)RelTypes.NEO_NODE, Direction.OUTGOING).getEndNode();
    }

    public static enum RelTypes implements RelationshipType
    {
        NEO_NODE,
        KNOWS,
        CODED_BY;

    }
}

