/*
 * Decompiled with CFR 0.152.
 */
package com.lordofthejars.nosqlunit.elasticsearch;

import com.lordofthejars.nosqlunit.core.FailureHandler;
import com.lordofthejars.nosqlunit.util.DeepEquals;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.codehaus.jackson.JsonGenerationException;
import org.codehaus.jackson.map.JsonMappingException;
import org.codehaus.jackson.map.ObjectMapper;
import org.elasticsearch.action.count.CountResponse;
import org.elasticsearch.action.get.GetRequest;
import org.elasticsearch.action.get.GetRequestBuilder;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.client.Client;

public class ElasticsearchAssertion {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    private ElasticsearchAssertion() {
    }

    public static final void strictAssertEquals(List<Map<String, Object>> expectedDocuments, Client client) {
        ElasticsearchAssertion.checkNumberOfDocuments(expectedDocuments, client);
        for (Map<String, Object> document : expectedDocuments) {
            Object object = document.get("document");
            if (object instanceof List) {
                List properties = (List)object;
                ArrayList<GetRequestBuilder> indexes = new ArrayList<GetRequestBuilder>();
                Map<String, Object> expectedDataOfDocument = new HashMap<String, Object>();
                for (Map property : properties) {
                    if (property.containsKey("index")) {
                        indexes.add(ElasticsearchAssertion.prepareGetIndex(property.get("index"), client));
                        continue;
                    }
                    if (!property.containsKey("data")) continue;
                    expectedDataOfDocument = ElasticsearchAssertion.dataOfDocument(property.get("data"));
                }
                ElasticsearchAssertion.checkIndicesWithDocument(indexes, expectedDataOfDocument);
                continue;
            }
            throw new IllegalArgumentException("Array of Indexes and Data are required.");
        }
    }

    private static void checkIndicesWithDocument(List<GetRequestBuilder> indexes, Map<String, Object> expectedDataOfDocument) throws Error {
        for (GetRequestBuilder getRequestBuilder : indexes) {
            GetResponse dataOfDocumentResponse = (GetResponse)getRequestBuilder.execute().actionGet();
            ElasticsearchAssertion.checkExistanceOfDocument(getRequestBuilder, dataOfDocumentResponse);
            ElasticsearchAssertion.checkDocumentEquality(expectedDataOfDocument, getRequestBuilder, dataOfDocumentResponse);
        }
    }

    private static void checkDocumentEquality(Map<String, Object> expectedDataOfDocument, GetRequestBuilder getRequestBuilder, GetResponse dataOfDocumentResponse) {
        LinkedHashMap dataOfDocument = new LinkedHashMap(dataOfDocumentResponse.getSource());
        boolean deepEquals = DeepEquals.deepEquals(dataOfDocument, expectedDataOfDocument);
        if (!deepEquals) {
            try {
                throw FailureHandler.createFailure((String)"Expected document for index: %s - type: %s - id: %s is %s, but %s was found.", (Object[])new Object[]{((GetRequest)getRequestBuilder.request()).index(), ((GetRequest)getRequestBuilder.request()).type(), ((GetRequest)getRequestBuilder.request()).id(), OBJECT_MAPPER.writeValueAsString(expectedDataOfDocument), OBJECT_MAPPER.writeValueAsString(dataOfDocument)});
            }
            catch (JsonGenerationException e) {
                throw new IllegalArgumentException(e);
            }
            catch (JsonMappingException e) {
                throw new IllegalArgumentException(e);
            }
            catch (IOException e) {
                throw new IllegalArgumentException(e);
            }
        }
    }

    private static void checkExistanceOfDocument(GetRequestBuilder getRequestBuilder, GetResponse dataOfDocumentResponse) throws Error {
        if (!dataOfDocumentResponse.exists()) {
            throw FailureHandler.createFailure((String)"Document with index: %s - type: %s - id: %s has not returned any document.", (Object[])new Object[]{((GetRequest)getRequestBuilder.request()).index(), ((GetRequest)getRequestBuilder.request()).type(), ((GetRequest)getRequestBuilder.request()).id()});
        }
    }

    private static void checkNumberOfDocuments(List<Map<String, Object>> expectedDocuments, Client client) throws Error {
        long numberOfInsertedDocuments;
        int expectedNumberOfElements = expectedDocuments.size();
        if ((long)expectedNumberOfElements != (numberOfInsertedDocuments = ElasticsearchAssertion.numberOfInsertedDocuments(client))) {
            throw FailureHandler.createFailure((String)"Expected number of documents are %s but %s has been found.", (Object[])new Object[]{expectedNumberOfElements, numberOfInsertedDocuments});
        }
    }

    private static GetRequestBuilder prepareGetIndex(Object object, Client client) {
        Map indexInformation = (Map)object;
        GetRequestBuilder prepareGet = client.prepareGet();
        if (indexInformation.containsKey("indexName")) {
            prepareGet.setIndex((String)indexInformation.get("indexName"));
        }
        if (indexInformation.containsKey("indexType")) {
            prepareGet.setType((String)indexInformation.get("indexType"));
        }
        if (indexInformation.containsKey("indexId")) {
            prepareGet.setId((String)indexInformation.get("indexId"));
        }
        return prepareGet;
    }

    private static Map<String, Object> dataOfDocument(Object object) {
        Map data = (Map)object;
        return data;
    }

    private static final long numberOfInsertedDocuments(Client client) {
        CountResponse numberOfElements = (CountResponse)client.prepareCount(new String[0]).execute().actionGet();
        return numberOfElements.count();
    }
}

