/*
 * Decompiled with CFR 0.152.
 */
package com.lordofthejars.nosqlunit.elasticsearch;

import com.lordofthejars.nosqlunit.elasticsearch.ElasticsearchConfiguration;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.transport.TransportClient;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.InetSocketTransportAddress;
import org.elasticsearch.common.transport.TransportAddress;

public class ManagedElasticsearchConfigurationBuilder {
    private ElasticsearchConfiguration elasticsearchConfiguration = new ElasticsearchConfiguration();

    private ManagedElasticsearchConfigurationBuilder() {
    }

    public static ManagedElasticsearchConfigurationBuilder managedElasticsearch() {
        return new ManagedElasticsearchConfigurationBuilder();
    }

    public ManagedElasticsearchConfigurationBuilder port(int port) {
        this.elasticsearchConfiguration.setPort(port);
        return this;
    }

    public ManagedElasticsearchConfigurationBuilder settings(Settings settings) {
        this.elasticsearchConfiguration.setSettings(settings);
        return this;
    }

    public ElasticsearchConfiguration build() {
        TransportClient client = this.getClient();
        client.addTransportAddress((TransportAddress)new InetSocketTransportAddress(this.elasticsearchConfiguration.getHost(), this.elasticsearchConfiguration.getPort()));
        this.elasticsearchConfiguration.setClient((Client)client);
        return this.elasticsearchConfiguration;
    }

    private TransportClient getClient() {
        if (this.elasticsearchConfiguration.getSettings() == null) {
            return new TransportClient();
        }
        return new TransportClient(this.elasticsearchConfiguration.getSettings());
    }
}

