/*
 * Decompiled with CFR 0.152.
 */
package com.lordofthejars.nosqlunit.elasticsearch;

import com.lordofthejars.nosqlunit.core.AbstractCustomizableDatabaseOperation;
import com.lordofthejars.nosqlunit.core.NoSqlAssertionError;
import com.lordofthejars.nosqlunit.elasticsearch.DefaultElasticsearchComparisonStrategy;
import com.lordofthejars.nosqlunit.elasticsearch.DefaultElasticsearchInsertionStrategy;
import com.lordofthejars.nosqlunit.elasticsearch.ElasticsearchConnectionCallback;
import java.io.InputStream;
import org.elasticsearch.action.count.CountResponse;
import org.elasticsearch.action.deletebyquery.DeleteByQueryRequestBuilder;
import org.elasticsearch.client.Client;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;

public class ElasticsearchOperation
extends AbstractCustomizableDatabaseOperation<ElasticsearchConnectionCallback, Client> {
    private Client client;

    public ElasticsearchOperation(Client client) {
        this.client = client;
        this.setInsertionStrategy(new DefaultElasticsearchInsertionStrategy());
        this.setComparisonStrategy(new DefaultElasticsearchComparisonStrategy());
    }

    public void insert(InputStream dataScript) {
        this.insertData(dataScript);
    }

    private void insertData(InputStream dataScript) {
        try {
            this.executeInsertion(new ElasticsearchConnectionCallback(){

                @Override
                public Client nodeClient() {
                    return ElasticsearchOperation.this.client;
                }
            }, dataScript);
        }
        catch (Throwable e) {
            throw new IllegalArgumentException(e);
        }
    }

    public void deleteAll() {
        this.clearDocuments();
    }

    private void clearDocuments() {
        if (this.isAnyIndexPresent()) {
            DeleteByQueryRequestBuilder deleteByQueryRequestBuilder = new DeleteByQueryRequestBuilder(this.client);
            deleteByQueryRequestBuilder.setQuery((QueryBuilder)QueryBuilders.matchAllQuery());
            deleteByQueryRequestBuilder.execute().actionGet();
            this.refreshNode();
        }
    }

    private boolean isAnyIndexPresent() {
        CountResponse numberOfElements = (CountResponse)this.client.prepareCount(new String[0]).execute().actionGet();
        return numberOfElements.getCount() > 0L;
    }

    private void refreshNode() {
        this.client.admin().indices().prepareRefresh(new String[0]).execute().actionGet();
    }

    public boolean databaseIs(InputStream expectedData) {
        try {
            return this.executeComparison(new ElasticsearchConnectionCallback(){

                @Override
                public Client nodeClient() {
                    return ElasticsearchOperation.this.client;
                }
            }, expectedData);
        }
        catch (NoSqlAssertionError e) {
            throw e;
        }
        catch (Throwable e) {
            throw new IllegalStateException(e);
        }
    }

    public Client connectionManager() {
        return this.client;
    }
}

