/*
 * Decompiled with CFR 0.152.
 */
package com.lordofthejars.nosqlunit.elasticsearch;

import com.lordofthejars.nosqlunit.core.AbstractLifecycleManager;
import com.lordofthejars.nosqlunit.core.CommandLineExecutor;
import com.lordofthejars.nosqlunit.core.IOUtils;
import com.lordofthejars.nosqlunit.core.OperatingSystem;
import com.lordofthejars.nosqlunit.core.OperatingSystemFamily;
import com.lordofthejars.nosqlunit.core.OperatingSystemResolver;
import com.lordofthejars.nosqlunit.core.OsNameSystemPropertyOperatingSystemResolver;
import com.lordofthejars.nosqlunit.elasticsearch.LowLevelElasticSearchOperations;
import com.lordofthejars.nosqlunit.env.SystemEnvironmentVariables;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManagedElasticsearchLifecycleManager
extends AbstractLifecycleManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(ManagedElasticsearchLifecycleManager.class);
    private static final String LOCALHOST = "localhost";
    protected static final String FOREGROUND_OPTION = "-f";
    protected static final String DEFAULT_ELASTICSEARCH_TARGET_PATH = "target" + File.separatorChar + "elasticsearch-temp";
    protected static final String ELASTICSEARCH_BINARY_DIRECTORY = "bin";
    protected static final String ELASTICSEARC_EXECUTABLE_X = "elasticsearch";
    protected static final String ELASTICSEARC_EXECUTABLE_W = "elasticsearch.bat";
    protected static final int DEFAULT_PORT = 9300;
    private Map<String, String> extraCommandArguments = new HashMap<String, String>();
    private List<String> singleCommandArguments = new ArrayList<String>();
    private CommandLineExecutor commandLineExecutor = new CommandLineExecutor();
    private OperatingSystemResolver operatingSystemResolver = new OsNameSystemPropertyOperatingSystemResolver();
    private LowLevelElasticSearchOperations lowLevelElasticSearchOperations = new LowLevelElasticSearchOperations();
    private String elasticsearchPath = SystemEnvironmentVariables.getEnvironmentOrPropertyVariable((String)"ES_HOME");
    private int port = 9300;
    private String targetPath = DEFAULT_ELASTICSEARCH_TARGET_PATH;
    private ProcessRunnable processRunnable;

    public String getHost() {
        return LOCALHOST;
    }

    public int getPort() {
        return this.port;
    }

    public void doStart() throws Throwable {
        LOGGER.info("Starting {} Elasticsearch instance.", (Object)this.elasticsearchPath);
        File dbPath = this.ensureDbPathDoesNotExitsAndReturnCompositePath();
        if (dbPath.mkdirs()) {
            this.startElasticsearchAsADaemon();
            boolean isServerUp = this.lowLevelElasticSearchOperations.assertThatConnectionToElasticsearchIsPossible(LOCALHOST, 9300);
            if (!isServerUp) {
                throw new IllegalStateException("Couldn't establish a connection with " + this.elasticsearchPath + " server at /127.0.0.1:" + this.port);
            }
        } else {
            throw new IllegalStateException("Db Path " + dbPath + " could not be created.");
        }
        LOGGER.info("Started {} Elasticsearch instance.", (Object)this.elasticsearchPath);
    }

    private void startElasticsearchAsADaemon() throws InterruptedException {
        CountDownLatch processIsReady = new CountDownLatch(1);
        this.processRunnable = new ProcessRunnable(processIsReady);
        Thread thread = new Thread(this.processRunnable);
        thread.start();
        processIsReady.await();
    }

    public void doStop() {
        LOGGER.info("Stopping {} Elasticsearch instance.", (Object)this.elasticsearchPath);
        try {
            if (this.processRunnable != null) {
                this.processRunnable.destroyProcess();
            }
        }
        finally {
            this.ensureDbPathDoesNotExitsAndReturnCompositePath();
        }
        LOGGER.info("Stopped {} Elasticsearch instance.", (Object)this.elasticsearchPath);
    }

    private List<String> buildOperationSystemProgramAndArguments() {
        ArrayList<String> programAndArguments = new ArrayList<String>();
        programAndArguments.add(this.getExecutablePath());
        if (this.isXBased()) {
            programAndArguments.add(FOREGROUND_OPTION);
        }
        for (String argument : this.singleCommandArguments) {
            programAndArguments.add(argument);
        }
        for (String argumentName : this.extraCommandArguments.keySet()) {
            programAndArguments.add(argumentName);
            programAndArguments.add(this.extraCommandArguments.get(argumentName));
        }
        return programAndArguments;
    }

    private boolean isXBased() {
        OperatingSystemFamily family = this.operatingSystemResolver.currentOperatingSystem().getFamily();
        return family != OperatingSystemFamily.WINDOWS;
    }

    private String getExecutablePath() {
        return String.valueOf(this.elasticsearchPath) + File.separatorChar + ELASTICSEARCH_BINARY_DIRECTORY + File.separatorChar + this.elasticsearchExecutable();
    }

    private File ensureDbPathDoesNotExitsAndReturnCompositePath() {
        File dbPath = new File(this.targetPath);
        if (dbPath.exists()) {
            IOUtils.deleteDir((File)dbPath);
        }
        return dbPath;
    }

    private String elasticsearchExecutable() {
        OperatingSystem operatingSystem = this.operatingSystemResolver.currentOperatingSystem();
        switch (operatingSystem.getFamily()) {
            case WINDOWS: {
                return ELASTICSEARC_EXECUTABLE_W;
            }
        }
        return ELASTICSEARC_EXECUTABLE_X;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setElasticsearchPath(String elasticsearchPath) {
        this.elasticsearchPath = elasticsearchPath;
    }

    public void setTargetPath(String targetPath) {
        this.targetPath = targetPath;
    }

    public void addExtraCommandLineArgument(String argumentName, String argumentValue) {
        this.extraCommandArguments.put(argumentName, argumentValue);
    }

    public void addSingleCommandLineArgument(String argument) {
        this.singleCommandArguments.add(argument);
    }

    public String getElasticsearchPath() {
        return this.elasticsearchPath;
    }

    protected void setCommandLineExecutor(CommandLineExecutor commandLineExecutor) {
        this.commandLineExecutor = commandLineExecutor;
    }

    protected void setOperatingSystemResolver(OperatingSystemResolver operatingSystemResolver) {
        this.operatingSystemResolver = operatingSystemResolver;
    }

    protected void setLowLevelElasticSearchOperations(LowLevelElasticSearchOperations lowLevelElasticSearchOperations) {
        this.lowLevelElasticSearchOperations = lowLevelElasticSearchOperations;
    }

    public class ProcessRunnable
    implements Runnable {
        private CountDownLatch processIsReady;
        private Process process;

        public ProcessRunnable(CountDownLatch processIsReady) {
            this.processIsReady = processIsReady;
        }

        @Override
        public void run() {
            try {
                try {
                    this.process = this.startProcess();
                }
                catch (IOException e) {
                    throw this.prepareException(e);
                }
            }
            finally {
                this.processIsReady.countDown();
            }
            try {
                this.process.waitFor();
            }
            catch (InterruptedException ie) {
                throw this.prepareException(ie);
            }
        }

        public void destroyProcess() {
            if (this.process != null) {
                this.process.destroy();
            }
        }

        private IllegalStateException prepareException(Exception e) {
            return new IllegalStateException("Elasticsearch [" + ManagedElasticsearchLifecycleManager.this.elasticsearchPath + "] could not be started. Next console message was thrown: " + e.getMessage());
        }

        private Process startProcess() throws IOException {
            return ManagedElasticsearchLifecycleManager.this.commandLineExecutor.startProcessInDirectoryAndArguments(ManagedElasticsearchLifecycleManager.this.targetPath, ManagedElasticsearchLifecycleManager.this.buildOperationSystemProgramAndArguments());
        }
    }
}

