/*
 * Decompiled with CFR 0.152.
 */
package com.lordofthejars.nosqlunit.elasticsearch;

import com.lordofthejars.nosqlunit.core.AbstractNoSqlTestRule;
import com.lordofthejars.nosqlunit.core.DatabaseOperation;
import com.lordofthejars.nosqlunit.elasticsearch.ElasticsearchConfiguration;
import com.lordofthejars.nosqlunit.elasticsearch.ElasticsearchOperation;
import com.lordofthejars.nosqlunit.elasticsearch.EmbeddedElasticsearchConfigurationBuilder;
import com.lordofthejars.nosqlunit.elasticsearch.ManagedElasticsearchConfigurationBuilder;
import org.elasticsearch.client.Client;

public class ElasticsearchRule
extends AbstractNoSqlTestRule {
    private static final String EXTENSION = "json";
    private DatabaseOperation<? extends Client> databaseOperation;

    public ElasticsearchRule(ElasticsearchConfiguration elasticsearchConfiguration) {
        super(elasticsearchConfiguration.getConnectionIdentifier());
        this.databaseOperation = new ElasticsearchOperation(elasticsearchConfiguration.getClient());
    }

    public ElasticsearchRule(ElasticsearchConfiguration elasticsearchConfiguration, Object target) {
        this(elasticsearchConfiguration);
        this.setTarget(target);
    }

    public DatabaseOperation getDatabaseOperation() {
        return this.databaseOperation;
    }

    public String getWorkingExtension() {
        return EXTENSION;
    }

    public void close() {
        ((Client)this.databaseOperation.connectionManager()).close();
    }

    public static class ElasticsearchRuleBuilder {
        private ElasticsearchConfiguration elasticsearchConfiguration;
        private Object target;

        private ElasticsearchRuleBuilder() {
        }

        public static ElasticsearchRuleBuilder newElasticsearchRule() {
            return new ElasticsearchRuleBuilder();
        }

        public ElasticsearchRuleBuilder configure(ElasticsearchConfiguration elasticsearchConfiguration) {
            this.elasticsearchConfiguration = elasticsearchConfiguration;
            return this;
        }

        public ElasticsearchRuleBuilder unitInstance(Object target) {
            this.target = target;
            return this;
        }

        public ElasticsearchRule defaultEmbeddedElasticsearch() {
            return new ElasticsearchRule(EmbeddedElasticsearchConfigurationBuilder.embeddedElasticsearch().build());
        }

        public ElasticsearchRule defaultManagedElasticsearch() {
            return new ElasticsearchRule(ManagedElasticsearchConfigurationBuilder.managedElasticsearch().build());
        }

        public ElasticsearchRule build() {
            if (this.elasticsearchConfiguration == null) {
                throw new IllegalArgumentException("Configuration object should be provided.");
            }
            return new ElasticsearchRule(this.elasticsearchConfiguration, this.target);
        }
    }
}

