/*
 * Decompiled with CFR 0.152.
 */
package com.lordofthejars.nosqlunit.elasticsearch;

import com.lordofthejars.nosqlunit.core.FailureHandler;
import com.lordofthejars.nosqlunit.elasticsearch.ElasticsearchConfiguration;
import com.lordofthejars.nosqlunit.elasticsearch.EmbeddedElasticsearchInstancesFactory;
import org.elasticsearch.node.Node;

public class EmbeddedElasticsearchConfigurationBuilder {
    private ElasticsearchConfiguration elasticsearchConfiguration = new ElasticsearchConfiguration();

    public static EmbeddedElasticsearchConfigurationBuilder embeddedElasticsearch() {
        return new EmbeddedElasticsearchConfigurationBuilder();
    }

    public EmbeddedElasticsearchConfigurationBuilder connectionIdentifier(String connectionIdentifier) {
        this.elasticsearchConfiguration.setConnectionIdentifier(connectionIdentifier);
        return this;
    }

    public ElasticsearchConfiguration build() {
        Node defaultEmbeddedInstance = (Node)EmbeddedElasticsearchInstancesFactory.getInstance().getDefaultEmbeddedInstance();
        if (defaultEmbeddedInstance == null) {
            throw FailureHandler.createIllegalStateFailure((String)"There is no EmbeddedElasticsearch rule with default target defined during test execution. Please create one using @Rule or @ClassRule before executing these tests.", (Object[])new Object[0]);
        }
        this.elasticsearchConfiguration.setClient(defaultEmbeddedInstance.client());
        return this.elasticsearchConfiguration;
    }
}

