/*
 * Decompiled with CFR 0.152.
 */
package com.lordofthejars.nosqlunit.hbase;

import com.lordofthejars.nosqlunit.core.NoSqlAssertionError;
import com.lordofthejars.nosqlunit.hbase.HBaseAssertion;
import com.lordofthejars.nosqlunit.hbase.HBaseComparisonStrategy;
import com.lordofthejars.nosqlunit.hbase.HBaseConnectionCallback;
import java.io.InputStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.ZooKeeperConnectionException;
import org.apache.hadoop.hbase.client.HConnection;
import org.apache.hadoop.hbase.client.HConnectionManager;

public class DefaultHBaseComparisonStrategy
implements HBaseComparisonStrategy {
    public boolean compare(HBaseConnectionCallback connection, InputStream dataset) throws NoSqlAssertionError, Throwable {
        HConnection hconnection = this.connection(connection.configuration());
        this.assertData(hconnection, dataset);
        return true;
    }

    private void assertData(HConnection connection, InputStream expectedData) {
        try {
            HBaseAssertion.strictAssertEquals(connection, expectedData);
        }
        catch (NoSqlAssertionError e) {
            throw e;
        }
        catch (Throwable e) {
            throw new IllegalArgumentException(e);
        }
    }

    private HConnection connection(Configuration configuration) {
        try {
            return HConnectionManager.createConnection((Configuration)configuration);
        }
        catch (ZooKeeperConnectionException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public void setIgnoreProperties(String[] ignoreProperties) {
    }
}

