/*
 * Decompiled with CFR 0.152.
 */
package com.lordofthejars.nosqlunit.hbase;

import com.lordofthejars.nosqlunit.core.FailureHandler;
import com.lordofthejars.nosqlunit.hbase.EmbeddedHBaseInstances;
import com.lordofthejars.nosqlunit.hbase.HBaseConfiguration;
import org.apache.hadoop.conf.Configuration;

public class EmbeddedHBaseConfigurationBuilder {
    private final HBaseConfiguration hBaseConfiguration = new HBaseConfiguration();

    private EmbeddedHBaseConfigurationBuilder() {
    }

    public static EmbeddedHBaseConfigurationBuilder newEmbeddedHBaseConfiguration() {
        return new EmbeddedHBaseConfigurationBuilder();
    }

    public EmbeddedHBaseConfigurationBuilder connectionIdentifier(String connectionIdentifier) {
        this.hBaseConfiguration.setConnectionIdentifier(connectionIdentifier);
        return this;
    }

    public HBaseConfiguration build() {
        Configuration defaultConfiguration = EmbeddedHBaseInstances.getInstance().getDefaultConfiguration();
        if (defaultConfiguration == null) {
            throw FailureHandler.createIllegalStateFailure((String)"There is no EmbeddedHBase rule during test execution. Please create one using @Rule or @ClassRule before executing these tests.", (Object[])new Object[0]);
        }
        this.hBaseConfiguration.setConfiguration(defaultConfiguration);
        return this.hBaseConfiguration;
    }

    public HBaseConfiguration buildFromTargetPath(String targetPath) {
        Configuration configuration = EmbeddedHBaseInstances.getInstance().getConfigurationByTargetPath(targetPath);
        if (configuration == null) {
            throw FailureHandler.createIllegalStateFailure((String)"There is no EmbeddedHBase rule with %s target defined during test execution. Please create one using @Rule or @ClassRule before executing these tests.", (Object[])new Object[]{targetPath});
        }
        this.hBaseConfiguration.setConfiguration(configuration);
        return this.hBaseConfiguration;
    }
}

