/*
 * Decompiled with CFR 0.152.
 */
package com.lordofthejars.nosqlunit.hbase;

import com.lordofthejars.nosqlunit.core.AbstractLifecycleManager;
import com.lordofthejars.nosqlunit.core.IOUtils;
import com.lordofthejars.nosqlunit.hbase.EmbeddedHBase;
import com.lordofthejars.nosqlunit.hbase.EmbeddedHBaseInstances;
import com.lordofthejars.nosqlunit.hbase.EmbeddedHBaseStarter;
import java.io.File;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmbeddedHBaseLifecycleManager
extends AbstractLifecycleManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(EmbeddedHBase.class);
    protected static final String LOCALHOST = "127.0.0.1";
    protected static final int PORT = 60000;
    protected static final String TARGET_DIRECTORY = "target/test-data";
    protected static final String DEFAULT_PERMISSIONS = "775";
    protected String filePermissions = "775";
    protected Configuration configuration;
    protected EmbeddedHBaseStarter embeddedHBaseStarter = new EmbeddedHBaseStarter();

    public String getHost() {
        return LOCALHOST;
    }

    public int getPort() {
        return 60000;
    }

    public void doStart() throws Throwable {
        LOGGER.info("Starting Embedded HBase instance.");
        Configuration config = this.configuration();
        this.startMiniCluster(config);
        EmbeddedHBaseInstances.getInstance().addHBaseConfiguration(this.configuration, "127.0.0.160000");
        LOGGER.info("Started Embedded HBase instance.");
    }

    private void startMiniCluster(Configuration config) throws Exception {
        HBaseTestingUtility testUtil = this.embeddedHBaseStarter.startSingleMiniCluster(config);
        this.configuration = testUtil.getConfiguration();
    }

    private Configuration configuration() {
        Configuration config = HBaseConfiguration.create();
        config.set("hbase.coprocessor.region.classes", "org.apache.hadoop.hbase.coprocessor.AggregateImplementation");
        config.set("dfs.datanode.data.dir.perm", this.filePermissions);
        return config;
    }

    public void doStop() {
        LOGGER.info("Stopping Embedded HBase instance.");
        EmbeddedHBaseInstances.getInstance().removeHBaseConfiguration("127.0.0.160000");
        this.shutdownMiniCluster();
        this.cleanTargetDirectory();
        LOGGER.info("Stopped Embedded HBase instance.");
    }

    private void shutdownMiniCluster() {
        this.embeddedHBaseStarter.stopMiniCluster();
    }

    private void cleanTargetDirectory() {
        File directory = new File(TARGET_DIRECTORY);
        if (directory.exists()) {
            IOUtils.deleteDir((File)directory);
        }
    }

    public String getFilePermissions() {
        return this.filePermissions;
    }

    public void setFilePermissions(String filePermissions) {
        this.filePermissions = filePermissions;
    }

    protected void setEmbeddedHBaseStarter(EmbeddedHBaseStarter embeddedHBaseStarter) {
        this.embeddedHBaseStarter = embeddedHBaseStarter;
    }
}

