/*
 * Decompiled with CFR 0.152.
 */
package com.lordofthejars.nosqlunit.hbase;

import ch.lambdaj.function.convert.Converter;
import com.lordofthejars.nosqlunit.core.FailureHandler;
import com.lordofthejars.nosqlunit.hbase.model.JsonDataSetParser;
import com.lordofthejars.nosqlunit.hbase.model.ParsedColumnFamilyModel;
import com.lordofthejars.nosqlunit.hbase.model.ParsedColumnModel;
import com.lordofthejars.nosqlunit.hbase.model.ParsedDataModel;
import com.lordofthejars.nosqlunit.hbase.model.ParsedRowModel;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.List;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.HConnection;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.coprocessor.AggregationClient;
import org.apache.hadoop.hbase.util.Bytes;

public class HBaseAssertion {
    public static void strictAssertEquals(HConnection connection, InputStream dataset) throws Throwable {
        JsonDataSetParser dataSetParser = new JsonDataSetParser();
        ParsedDataModel parsedDataset = dataSetParser.parse(dataset);
        Configuration configuration = connection.getConfiguration();
        HBaseAdmin hBaseAdmin = new HBaseAdmin(configuration);
        byte[] expectedTableName = HBaseAssertion.checkTableName(parsedDataset, hBaseAdmin);
        HTableDescriptor tableDescriptor = hBaseAdmin.getTableDescriptor(expectedTableName);
        List<ParsedColumnFamilyModel> expectedColumnFamilies = parsedDataset.getColumnFamilies();
        HBaseAssertion.checkNumberOfColumnFamilies(tableDescriptor, expectedColumnFamilies);
        HBaseAssertion.checkColumnFamilies(connection, configuration, expectedTableName, tableDescriptor, expectedColumnFamilies);
    }

    private static void checkColumnFamilies(HConnection connection, Configuration configuration, byte[] expectedTableName, HTableDescriptor tableDescriptor, List<ParsedColumnFamilyModel> expectedColumnFamilies) throws Error, Throwable, IOException {
        for (ParsedColumnFamilyModel parsedColumnFamilyModel : expectedColumnFamilies) {
            HBaseAssertion.checkColumnFamily(connection, configuration, expectedTableName, tableDescriptor, expectedColumnFamilies, parsedColumnFamilyModel);
        }
    }

    private static void checkColumnFamily(HConnection connection, Configuration configuration, byte[] expectedTableName, HTableDescriptor tableDescriptor, List<ParsedColumnFamilyModel> expectedColumnFamilies, ParsedColumnFamilyModel parsedColumnFamilyModel) throws Error, Throwable, IOException {
        byte[] expectedFamilyName = HBaseAssertion.checkColumnFamilyName(tableDescriptor, parsedColumnFamilyModel);
        List<ParsedRowModel> expectedRows = HBaseAssertion.checkNumberOfRows(connection, expectedTableName, parsedColumnFamilyModel, expectedFamilyName);
        HBaseAssertion.checkRows(configuration, expectedTableName, expectedColumnFamilies, parsedColumnFamilyModel, expectedRows);
    }

    private static void checkRows(Configuration configuration, byte[] expectedTableName, List<ParsedColumnFamilyModel> expectedColumnFamilies, ParsedColumnFamilyModel parsedColumnFamilyModel, List<ParsedRowModel> expectedRows) throws IOException, Error {
        for (ParsedRowModel parsedRowModel : expectedRows) {
            HBaseAssertion.checkRow(configuration, expectedTableName, expectedColumnFamilies, parsedColumnFamilyModel, parsedRowModel);
        }
    }

    private static void checkRow(Configuration configuration, byte[] expectedTableName, List<ParsedColumnFamilyModel> expectedColumnFamilies, ParsedColumnFamilyModel parsedColumnFamilyModel, ParsedRowModel parsedRowModel) throws IOException, Error {
        HTable table = new HTable(configuration, expectedTableName);
        Get get = new Get(parsedRowModel.getKeyInBytes());
        get.addFamily(Bytes.toBytes((String)parsedColumnFamilyModel.getName()));
        Result result = table.get(get);
        HBaseAssertion.checkRowName(parsedRowModel, result);
        KeyValue[] raws = result.raw();
        HBaseAssertion.checkNumberOfColumns(expectedColumnFamilies, parsedColumnFamilyModel, raws, parsedRowModel);
        HBaseAssertion.checkRowValues(raws, parsedRowModel);
    }

    private static void checkRowName(ParsedRowModel parsedRowModel, Result result) throws Error {
        if (result.isEmpty()) {
            throw FailureHandler.createFailure((String)"Expected row name is %s but is not found.", (Object[])new Object[]{parsedRowModel.getKey()});
        }
    }

    private static void checkRowValues(KeyValue[] raws, ParsedRowModel parsedRowModel) throws Error {
        List<ParsedColumnModel> expectedColumns = parsedRowModel.getColumns();
        for (KeyValue raw : raws) {
            byte[] qualifier = raw.getQualifier();
            byte[] value = raw.getValue();
            boolean found = false;
            for (ParsedColumnModel expectedColumn : expectedColumns) {
                if (!Bytes.equals((byte[])Bytes.toBytes((String)expectedColumn.getName()), (byte[])qualifier)) continue;
                if (!Bytes.equals((byte[])expectedColumn.getValueInBytes(), (byte[])value)) break;
                found = true;
                break;
            }
            if (found) continue;
            throw FailureHandler.createFailure((String)"Expected column are not found. Encountered column with name %s and value %s is not found.", (Object[])new Object[]{HBaseAssertion.getName(raws), HBaseAssertion.getValue(raws)});
        }
    }

    private static void checkNumberOfColumns(List<ParsedColumnFamilyModel> expectedColumnFamilies, ParsedColumnFamilyModel parsedColumnFamilyModel, KeyValue[] raws, ParsedRowModel parsedRowModel) throws Error {
        int numberOfColumns = raws.length;
        List<ParsedColumnModel> expectedColumns = parsedRowModel.getColumns();
        int expectedNumberOfColumns = expectedColumns.size();
        if (numberOfColumns != expectedNumberOfColumns) {
            throw FailureHandler.createFailure((String)"Expected number of columns for %s are %s but %s are found.", (Object[])new Object[]{parsedRowModel.getKey(), expectedNumberOfColumns, numberOfColumns});
        }
    }

    private static List<ParsedRowModel> checkNumberOfRows(HConnection connection, byte[] expectedTableName, ParsedColumnFamilyModel parsedColumnFamilyModel, byte[] expectedFamilyName) throws Throwable, Error {
        int expectedNumberOfRows;
        List<ParsedRowModel> expectedRows = parsedColumnFamilyModel.getRows();
        long numberOfRows = HBaseAssertion.countNumberOfRows(connection, expectedTableName, expectedFamilyName);
        if (numberOfRows != (long)(expectedNumberOfRows = expectedRows.size())) {
            throw FailureHandler.createFailure((String)"Expected number of rows are %s but %s are found.", (Object[])new Object[]{expectedNumberOfRows, numberOfRows});
        }
        return expectedRows;
    }

    private static byte[] checkColumnFamilyName(HTableDescriptor tableDescriptor, ParsedColumnFamilyModel parsedColumnFamilyModel) throws Error {
        byte[] expectedFamilyName = parsedColumnFamilyModel.getName().getBytes();
        if (!tableDescriptor.hasFamily(expectedFamilyName)) {
            throw FailureHandler.createFailure((String)"Expected name of column family is %s but was not found.", (Object[])new Object[]{parsedColumnFamilyModel.getName()});
        }
        return expectedFamilyName;
    }

    private static void checkNumberOfColumnFamilies(HTableDescriptor tableDescriptor, List<ParsedColumnFamilyModel> expectedColumnFamilies) throws Error {
        int currentNumberOfColumnFamilies;
        Set currentFamiliesKeys = tableDescriptor.getFamiliesKeys();
        int expectedNumberOfColumnFamilies = expectedColumnFamilies.size();
        if (expectedNumberOfColumnFamilies != (currentNumberOfColumnFamilies = currentFamiliesKeys.size())) {
            throw FailureHandler.createFailure((String)"Expected number of column families are %s but was %s.", (Object[])new Object[]{expectedNumberOfColumnFamilies, currentNumberOfColumnFamilies});
        }
    }

    private static byte[] checkTableName(ParsedDataModel parsedDataset, HBaseAdmin hBaseAdmin) throws IOException, Error {
        byte[] expectedTableName = parsedDataset.getName().getBytes();
        if (!hBaseAdmin.tableExists(expectedTableName)) {
            throw FailureHandler.createFailure((String)"Table %s is not found.", (Object[])new Object[]{parsedDataset.getName()});
        }
        return expectedTableName;
    }

    private static String getValue(KeyValue[] raws) {
        return (String)HBaseAssertion.toStringValue().convert((Object)raws[0].getValue());
    }

    private static String getName(KeyValue[] raws) {
        return (String)HBaseAssertion.toStringValue().convert((Object)raws[0].getQualifier());
    }

    private static Converter<byte[], String> toStringValue() {
        return new Converter<byte[], String>(){

            public String convert(byte[] from) {
                try {
                    return new String(from, "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    throw new IllegalArgumentException(e);
                }
            }
        };
    }

    private static long countNumberOfRows(HConnection connection, byte[] tableName, byte[] columnFamily) throws Throwable {
        AggregationClient aggregationClient = new AggregationClient(connection.getConfiguration());
        Scan scan = new Scan();
        scan.addFamily(columnFamily);
        return aggregationClient.rowCount(tableName, null, scan);
    }
}

