/*
 * Decompiled with CFR 0.152.
 */
package com.lordofthejars.nosqlunit.hbase;

import com.lordofthejars.nosqlunit.core.AbstractCustomizableDatabaseOperation;
import com.lordofthejars.nosqlunit.core.NoSqlAssertionError;
import com.lordofthejars.nosqlunit.hbase.DefaultHBaseComparisonStrategy;
import com.lordofthejars.nosqlunit.hbase.DefaultHBaseInsertionStrategy;
import com.lordofthejars.nosqlunit.hbase.HBaseConfiguration;
import com.lordofthejars.nosqlunit.hbase.HBaseConnectionCallback;
import java.io.IOException;
import java.io.InputStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.MasterNotRunningException;
import org.apache.hadoop.hbase.ZooKeeperConnectionException;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.HConnection;
import org.apache.hadoop.hbase.client.HConnectionManager;

public class HBaseOperation
extends AbstractCustomizableDatabaseOperation<HBaseConnectionCallback, Configuration> {
    private Configuration configuration;

    public HBaseOperation(HBaseConfiguration configuration) {
        this.configuration = configuration.getConfiguration();
        this.setInsertionStrategy(new DefaultHBaseInsertionStrategy());
        this.setComparisonStrategy(new DefaultHBaseComparisonStrategy());
    }

    public void insert(InputStream dataScript) {
        this.insertData(dataScript);
    }

    private void insertData(InputStream dataScript) {
        try {
            this.executeInsertion(new HBaseConnectionCallback(){

                @Override
                public Configuration configuration() {
                    return HBaseOperation.this.configuration;
                }
            }, dataScript);
        }
        catch (Throwable e) {
            throw new IllegalArgumentException("Unexpected error reading data set file.", e);
        }
    }

    public void deleteAll() {
        HConnection connection = this.connection();
        HBaseAdmin hBaseAdmin = this.hBaseAdmin(connection);
        this.deleteAllTables(connection, hBaseAdmin);
    }

    private void deleteAllTables(HConnection connection, HBaseAdmin hBaseAdmin) {
        try {
            HTableDescriptor[] listTables;
            for (HTableDescriptor hTableDescriptor : listTables = connection.listTables()) {
                byte[] tableName = hTableDescriptor.getName();
                hBaseAdmin.disableTable(tableName);
                hBaseAdmin.deleteTable(tableName);
            }
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public boolean databaseIs(InputStream expectedData) {
        return this.compareData(expectedData);
    }

    private boolean compareData(InputStream expectedData) throws NoSqlAssertionError {
        try {
            return this.executeComparison(new HBaseConnectionCallback(){

                @Override
                public Configuration configuration() {
                    return HBaseOperation.this.configuration;
                }
            }, expectedData);
        }
        catch (NoSqlAssertionError e) {
            throw e;
        }
        catch (Throwable e) {
            throw new IllegalStateException(e);
        }
    }

    public Configuration connectionManager() {
        return this.configuration;
    }

    private HBaseAdmin hBaseAdmin(HConnection connection) {
        try {
            return new HBaseAdmin(connection);
        }
        catch (MasterNotRunningException e) {
            throw new IllegalArgumentException(e);
        }
        catch (ZooKeeperConnectionException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private HConnection connection() {
        try {
            return HConnectionManager.createConnection((Configuration)this.configuration);
        }
        catch (ZooKeeperConnectionException e) {
            throw new IllegalArgumentException(e);
        }
    }
}

