/*
 * Decompiled with CFR 0.152.
 */
package com.lordofthejars.nosqlunit.hbase;

import com.lordofthejars.nosqlunit.core.AbstractNoSqlTestRule;
import com.lordofthejars.nosqlunit.core.DatabaseOperation;
import com.lordofthejars.nosqlunit.hbase.EmbeddedHBaseConfigurationBuilder;
import com.lordofthejars.nosqlunit.hbase.HBaseConfiguration;
import com.lordofthejars.nosqlunit.hbase.HBaseOperation;
import com.lordofthejars.nosqlunit.hbase.ManagedHBaseConfigurationBuilder;
import org.apache.hadoop.conf.Configuration;

public class HBaseRule
extends AbstractNoSqlTestRule {
    private static final String EXTENSION = "json";
    private DatabaseOperation<Configuration> databaseOperation;

    public HBaseRule(HBaseConfiguration hBaseConfiguration) {
        super(hBaseConfiguration.getConnectionIdentifier());
        this.databaseOperation = new HBaseOperation(hBaseConfiguration);
    }

    public HBaseRule(HBaseConfiguration hBaseConfiguration, Object target) {
        super(hBaseConfiguration.getConnectionIdentifier());
        this.setTarget(target);
        this.databaseOperation = new HBaseOperation(hBaseConfiguration);
    }

    public DatabaseOperation<Configuration> getDatabaseOperation() {
        return this.databaseOperation;
    }

    public String getWorkingExtension() {
        return EXTENSION;
    }

    public static class HBaseRuleBuilder {
        private HBaseConfiguration hBaseConfiguration;
        private Object target;

        private HBaseRuleBuilder() {
        }

        public static HBaseRuleBuilder newHBaseRule() {
            return new HBaseRuleBuilder();
        }

        public HBaseRuleBuilder configure(HBaseConfiguration hBaseConfiguration) {
            this.hBaseConfiguration = hBaseConfiguration;
            return this;
        }

        public HBaseRuleBuilder unitInstance(Object target) {
            this.target = target;
            return this;
        }

        public HBaseRule defaultEmbeddedHBase() {
            return new HBaseRule(EmbeddedHBaseConfigurationBuilder.newEmbeddedHBaseConfiguration().build());
        }

        @Deprecated
        public HBaseRule defaultEmbeddedHBase(Object target) {
            return new HBaseRule(EmbeddedHBaseConfigurationBuilder.newEmbeddedHBaseConfiguration().build(), target);
        }

        public HBaseRule defaultManagedHBase() {
            return new HBaseRule(ManagedHBaseConfigurationBuilder.newManagedHBaseConfiguration().build());
        }

        @Deprecated
        public HBaseRule defaultManagedHBase(Object target) {
            return new HBaseRule(ManagedHBaseConfigurationBuilder.newManagedHBaseConfiguration().build(), target);
        }

        public HBaseRule build() {
            if (this.hBaseConfiguration == null) {
                throw new IllegalArgumentException("Configuration object should be provided.");
            }
            return new HBaseRule(this.hBaseConfiguration, this.target);
        }
    }
}

