/*
 * Decompiled with CFR 0.152.
 */
package com.lordofthejars.nosqlunit.hbase;

import com.lordofthejars.nosqlunit.core.AbstractLifecycleManager;
import com.lordofthejars.nosqlunit.core.CommandLineExecutor;
import com.lordofthejars.nosqlunit.core.IOUtils;
import com.lordofthejars.nosqlunit.core.OperatingSystem;
import com.lordofthejars.nosqlunit.core.OperatingSystemResolver;
import com.lordofthejars.nosqlunit.core.OsNameSystemPropertyOperatingSystemResolver;
import com.lordofthejars.nosqlunit.env.SystemEnvironmentVariables;
import com.lordofthejars.nosqlunit.hbase.HBaseUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManagedHBaseLifecycleManager
extends AbstractLifecycleManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(ManagedHBaseLifecycleManager.class);
    private static final int NUM_RETRIES_TO_CHECK_SERVER_UP = 3;
    protected static final String LOCALHOST = "127.0.0.1";
    protected static final int PORT = 60000;
    protected static final String DEFAULT_HBASE_TARGET_PATH = "target" + File.separatorChar + "hbase-temp";
    protected static final String HBASE_BINARY_DIRECTORY = "bin";
    protected static final String START_HBASE_EXECUTABLE_X = "start-hbase.sh";
    protected static final String STOP_HBASE_EXECUTABLE_X = "stop-hbase.sh";
    private CommandLineExecutor commandLineExecutor = new CommandLineExecutor();
    private OperatingSystemResolver operatingSystemResolver = new OsNameSystemPropertyOperatingSystemResolver();
    private HBaseUtils hBaseUtils = new HBaseUtils();
    private String targetPath = DEFAULT_HBASE_TARGET_PATH;
    private String hBasePath = SystemEnvironmentVariables.getEnvironmentOrPropertyVariable((String)"HBASE_HOME");
    private int port = 60000;
    private Map<String, String> extraCommandArguments = new HashMap<String, String>();
    private List<String> singleCommandArguments = new ArrayList<String>();

    public String getHost() {
        return LOCALHOST;
    }

    public int getPort() {
        return this.port;
    }

    public void doStart() throws Throwable {
        LOGGER.info("Starting {} HBase instance.", (Object)this.hBasePath);
        File targetPathDirectory = this.ensureTargetPathDoesNotExitsAndReturnCompositePath();
        if (!targetPathDirectory.mkdirs()) {
            throw new IllegalStateException("Target Path " + targetPathDirectory + " could not be created.");
        }
        this.startHBaseAsADaemon();
        this.checkRunningServer();
        LOGGER.info("Started {} HBase instance.", (Object)this.hBasePath);
    }

    private void checkRunningServer() throws InterruptedException {
        boolean isServerUp = this.assertThatConnectionIsPossible();
        if (!isServerUp) {
            throw new IllegalStateException("Couldn't establish a connection with " + this.hBasePath + " server at /127.0.0.1:" + this.port);
        }
    }

    public void doStop() {
        LOGGER.info("Stopping {} HBase instance.", (Object)this.hBasePath);
        try {
            this.stopHBase();
        }
        catch (InterruptedException e) {
            throw new IllegalArgumentException(e);
        }
        finally {
            this.ensureTargetPathDoesNotExitsAndReturnCompositePath();
        }
        LOGGER.info("Stopped {} HBase instance.", (Object)this.hBasePath);
    }

    private List<String> startHBaseAsADaemon() throws InterruptedException {
        try {
            Process pwd = this.startProcess();
            List<String> lines = this.getConsoleOutput(pwd);
            pwd.waitFor();
            if (pwd.exitValue() != 0) {
                throw new IllegalStateException("HBase start [" + this.hBasePath + "port " + this.port + "] could not be started. Next console message was thrown: " + lines);
            }
            return lines;
        }
        catch (IOException e) {
            throw new IllegalStateException("HBase start [" + this.hBasePath + "port " + this.port + "] could not be started. Next console message was thrown: " + e.getMessage());
        }
    }

    private boolean assertThatConnectionIsPossible() throws InterruptedException {
        Configuration config = HBaseConfiguration.create();
        for (int i = 0; i < 3; ++i) {
            if (this.hBaseUtils.isConnectionPossible(config)) {
                return true;
            }
            TimeUnit.SECONDS.sleep(3L);
        }
        return false;
    }

    private List<String> stopHBase() throws InterruptedException {
        try {
            Process pwd = this.stopProcess();
            List<String> lines = this.getConsoleOutput(pwd);
            pwd.waitFor();
            if (pwd.exitValue() != 0) {
                throw new IllegalStateException("HBase stop [" + this.hBasePath + "port " + this.port + "] could not be started. Next console message was thrown: " + lines);
            }
            return lines;
        }
        catch (IOException e) {
            throw new IllegalStateException("HBase stop [" + this.hBasePath + "port " + this.port + "] could not be started. Next console message was thrown: " + e.getMessage());
        }
    }

    private Process startProcess() throws IOException {
        return this.commandLineExecutor.startProcessInDirectoryAndArguments(this.targetPath, this.buildOperationSystemProgramAndArguments());
    }

    private Process stopProcess() throws IOException {
        return this.commandLineExecutor.startProcessInDirectoryAndArguments(this.targetPath, this.buildStopProgram());
    }

    private List<String> buildStopProgram() {
        ArrayList<String> programAndArguments = new ArrayList<String>();
        programAndArguments.add(this.getStoppingExecutablePath());
        return programAndArguments;
    }

    private List<String> buildOperationSystemProgramAndArguments() {
        ArrayList<String> programAndArguments = new ArrayList<String>();
        programAndArguments.add(this.getExecutablePath());
        for (String argument : this.singleCommandArguments) {
            programAndArguments.add(argument);
        }
        for (String argumentName : this.extraCommandArguments.keySet()) {
            programAndArguments.add(argumentName);
            programAndArguments.add(this.extraCommandArguments.get(argumentName));
        }
        return programAndArguments;
    }

    private String getStoppingExecutablePath() {
        return this.hBasePath + File.separatorChar + HBASE_BINARY_DIRECTORY + File.separatorChar + STOP_HBASE_EXECUTABLE_X;
    }

    private String getExecutablePath() {
        return this.hBasePath + File.separatorChar + HBASE_BINARY_DIRECTORY + File.separatorChar + this.hBaseExecutable();
    }

    private String hBaseExecutable() {
        OperatingSystem operatingSystem = this.operatingSystemResolver.currentOperatingSystem();
        switch (operatingSystem.getFamily()) {
            case WINDOWS: {
                throw new IllegalArgumentException("HBase is not supported in Windows Systems.");
            }
        }
        return START_HBASE_EXECUTABLE_X;
    }

    private List<String> getConsoleOutput(Process pwd) throws IOException {
        return this.commandLineExecutor.getConsoleOutput(pwd);
    }

    private File ensureTargetPathDoesNotExitsAndReturnCompositePath() {
        File dbPath = new File(this.targetPath);
        if (dbPath.exists()) {
            IOUtils.deleteDir((File)dbPath);
        }
        return dbPath;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void addExtraCommandLineArgument(String argumentName, String argumentValue) {
        this.extraCommandArguments.put(argumentName, argumentValue);
    }

    public void addSingleCommandLineArgument(String argument) {
        this.singleCommandArguments.add(argument);
    }

    public void setTargetPath(String targetPath) {
        this.targetPath = targetPath;
    }

    public void setHBasePath(String hBasePath) {
        this.hBasePath = hBasePath;
    }

    public String getHBasePath() {
        return this.hBasePath;
    }

    protected void setOperatingSystemResolver(OperatingSystemResolver operatingSystemResolver) {
        this.operatingSystemResolver = operatingSystemResolver;
    }

    protected void setCommandLineExecutor(CommandLineExecutor commandLineExecutor) {
        this.commandLineExecutor = commandLineExecutor;
    }

    protected void setHBaseUtils(HBaseUtils hBaseUtils) {
        this.hBaseUtils = hBaseUtils;
    }
}

