/*
 * Decompiled with CFR 0.152.
 */
package com.lordofthejars.nosqlunit.infinispan;

import com.lordofthejars.nosqlunit.core.FailureHandler;
import com.lordofthejars.nosqlunit.infinispan.EmbeddedInfinispanInstancesFactory;
import com.lordofthejars.nosqlunit.infinispan.InfinispanConfiguration;
import org.infinispan.Cache;
import org.infinispan.api.BasicCache;
import org.infinispan.manager.EmbeddedCacheManager;

public class EmbeddedInfinispanConfigurationBuilder {
    private final InfinispanConfiguration infinispanConfiguration = new InfinispanConfiguration();

    private EmbeddedInfinispanConfigurationBuilder() {
    }

    public static EmbeddedInfinispanConfigurationBuilder newEmbeddedInfinispanConfiguration() {
        return new EmbeddedInfinispanConfigurationBuilder();
    }

    public EmbeddedInfinispanConfigurationBuilder connectionIdentifier(String connectionIdentifier) {
        this.infinispanConfiguration.setConnectionIdentifier(connectionIdentifier);
        return this;
    }

    public EmbeddedInfinispanConfigurationBuilder cacheName(String cacheName) {
        this.infinispanConfiguration.setCacheName(cacheName);
        return this;
    }

    public InfinispanConfiguration build() {
        EmbeddedCacheManager defaultEmbeddedInstance = (EmbeddedCacheManager)EmbeddedInfinispanInstancesFactory.getInstance().getDefaultEmbeddedInstance();
        if (defaultEmbeddedInstance == null) {
            throw FailureHandler.createIllegalStateFailure((String)"There is no EmbeddedInfinispan rule with default target defined during test execution. Please create one using @Rule or @ClassRule before executing these tests.", (Object[])new Object[0]);
        }
        Cache basicCache = this.infinispanConfiguration.getCacheName() == null ? defaultEmbeddedInstance.getCache() : defaultEmbeddedInstance.getCache(this.infinispanConfiguration.getCacheName());
        this.infinispanConfiguration.setCache((BasicCache<Object, Object>)basicCache);
        return this.infinispanConfiguration;
    }

    public InfinispanConfiguration buildFromTargetPath(String targetPath) {
        EmbeddedCacheManager defaultEmbeddedInstance = (EmbeddedCacheManager)EmbeddedInfinispanInstancesFactory.getInstance().getEmbeddedByTargetPath(targetPath);
        if (defaultEmbeddedInstance == null) {
            throw FailureHandler.createIllegalStateFailure((String)"There is no EmbeddedInfinispan rule with %s target defined during test execution. Please create one using @Rule or @ClassRule before executing these tests.", (Object[])new Object[]{targetPath});
        }
        Cache basicCache = this.infinispanConfiguration.getCacheName() == null ? defaultEmbeddedInstance.getCache() : defaultEmbeddedInstance.getCache(this.infinispanConfiguration.getCacheName());
        this.infinispanConfiguration.setCache((BasicCache<Object, Object>)basicCache);
        return this.infinispanConfiguration;
    }
}

