/*
 * Decompiled with CFR 0.152.
 */
package com.lordofthejars.nosqlunit.infinispan;

import com.lordofthejars.nosqlunit.core.AbstractLifecycleManager;
import com.lordofthejars.nosqlunit.core.CommandLineExecutor;
import com.lordofthejars.nosqlunit.core.IOUtils;
import com.lordofthejars.nosqlunit.core.OperatingSystem;
import com.lordofthejars.nosqlunit.core.OperatingSystemResolver;
import com.lordofthejars.nosqlunit.core.OsNameSystemPropertyOperatingSystemResolver;
import com.lordofthejars.nosqlunit.env.SystemEnvironmentVariables;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManagedInfinispanLifecycleManager
extends AbstractLifecycleManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(ManagedInfinispanLifecycleManager.class);
    Process pwd;
    private static final String LOCALHOST = "127.0.0.1";
    public static final int DEFAULT_PORT = 11222;
    protected static final String DEFAULT_INFINISPAN_TARGET_PATH = "target" + File.separatorChar + "infinispan-temp";
    protected static final String INFINISPAN_BINARY_DIRECTORY = "bin";
    protected static final String INFINISPAN_EXECUTABLE_X = "startServer.sh";
    protected static final String INFINISPAN_EXECUTABLE_W = "startServer.bat";
    protected static final String PORT_COMMAND_LINE_ARGUMENT_NAME = "--port";
    protected static final String PROTOCOL_COMMAND_LINE_ARGUMENT_NAME = "--protocol";
    protected static final String PROTOCOL_COMMAND_LINE_DEFAULT_VALUE = "hotrod";
    private int port = 11222;
    private String protocol = "hotrod";
    private String targetPath = DEFAULT_INFINISPAN_TARGET_PATH;
    private String infinispanPath = SystemEnvironmentVariables.getEnvironmentOrPropertyVariable((String)"INFINISPAN_HOME");
    private Map<String, String> extraCommandArguments = new HashMap<String, String>();
    private List<String> singleCommandArguments = new ArrayList<String>();
    private CommandLineExecutor commandLineExecutor = new CommandLineExecutor();
    private OperatingSystemResolver operatingSystemResolver = new OsNameSystemPropertyOperatingSystemResolver();
    private boolean closing = false;

    public String getHost() {
        return LOCALHOST;
    }

    public int getPort() {
        return this.port;
    }

    public void doStart() throws Throwable {
        LOGGER.info("Starting {} Infinispan instance.", (Object)this.infinispanPath);
        File targetPathDirectory = this.ensureTargetPathDoesNotExitsAndReturnCompositePath();
        if (!targetPathDirectory.mkdirs()) {
            throw new IllegalStateException("Target Path " + targetPathDirectory + " could not be created.");
        }
        this.startInfinispanAsDaemon();
        LOGGER.info("Started {} Infinispan instance.", (Object)this.infinispanPath);
    }

    private void startInfinispanAsDaemon() {
        final CountDownLatch startupLatch = new CountDownLatch(1);
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    ManagedInfinispanLifecycleManager.this.startInfinispanProcess();
                    startupLatch.countDown();
                }
                catch (InterruptedException e) {
                    throw new IllegalStateException(e);
                }
            }
        }).start();
        try {
            startupLatch.await(5L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            throw new AssertionError((Object)e);
        }
    }

    private List<String> startInfinispanProcess() throws InterruptedException {
        try {
            this.pwd = this.startProcess();
            this.pwd.waitFor();
            if (this.pwd.exitValue() != 0) {
                List<String> consoleOutput = this.getConsoleOutput(this.pwd);
                throw new IllegalStateException("Infinispan [" + this.infinispanPath + " at port " + this.port + " and protocol " + this.protocol + "] could not be started. Next console message was thrown: " + consoleOutput);
            }
            return null;
        }
        catch (IOException e) {
            if (!this.closing) {
                throw new IllegalStateException("Infinispan [" + this.infinispanPath + " at port " + this.port + " and protocol " + this.protocol + "] could not be started. Next console message was thrown: " + e.getMessage());
            }
            return null;
        }
    }

    private Process startProcess() throws IOException {
        return this.commandLineExecutor.startProcessInDirectoryAndArguments(this.targetPath, this.buildOperationSystemProgramAndArguments());
    }

    private List<String> buildOperationSystemProgramAndArguments() {
        ArrayList<String> programAndArguments = new ArrayList<String>();
        programAndArguments.add(this.getExecutablePath());
        this.addPort(programAndArguments);
        this.addProtocol(programAndArguments);
        this.addSingleArguments(programAndArguments);
        this.addCommandArguments(programAndArguments);
        return programAndArguments;
    }

    private void addCommandArguments(List<String> programAndArguments) {
        for (String argumentName : this.extraCommandArguments.keySet()) {
            programAndArguments.add(argumentName);
            programAndArguments.add(this.extraCommandArguments.get(argumentName));
        }
    }

    private void addSingleArguments(List<String> programAndArguments) {
        for (String argument : this.singleCommandArguments) {
            programAndArguments.add(argument);
        }
    }

    private void addProtocol(List<String> programAndArguments) {
        programAndArguments.add(PROTOCOL_COMMAND_LINE_ARGUMENT_NAME);
        programAndArguments.add(PROTOCOL_COMMAND_LINE_DEFAULT_VALUE);
    }

    private void addPort(List<String> programAndArguments) {
        programAndArguments.add(PORT_COMMAND_LINE_ARGUMENT_NAME);
        programAndArguments.add(Integer.toString(this.port));
    }

    private String getExecutablePath() {
        return this.infinispanPath + File.separatorChar + INFINISPAN_BINARY_DIRECTORY + File.separatorChar + this.infinispanExecutable();
    }

    private String infinispanExecutable() {
        OperatingSystem operatingSystem = this.operatingSystemResolver.currentOperatingSystem();
        switch (operatingSystem.getFamily()) {
            case WINDOWS: {
                return INFINISPAN_EXECUTABLE_W;
            }
        }
        return INFINISPAN_EXECUTABLE_X;
    }

    private List<String> getConsoleOutput(Process pwd) throws IOException {
        return this.commandLineExecutor.getConsoleOutput(pwd);
    }

    public void doStop() {
        LOGGER.info("Stopping {} Infinispan instance.", (Object)this.infinispanPath);
        try {
            this.closing = true;
            this.stopInfinispan();
        }
        catch (InterruptedException e) {
            throw new IllegalStateException(e);
        }
        finally {
            this.ensureTargetPathDoesNotExitsAndReturnCompositePath();
        }
        LOGGER.info("Stopped {} Infinispan instance.", (Object)this.infinispanPath);
    }

    private void stopInfinispan() throws InterruptedException {
        if (this.isProcessAlive()) {
            this.pwd.destroy();
            TimeUnit.SECONDS.sleep(2L);
        }
    }

    private boolean isProcessAlive() {
        return this.pwd != null;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setTargetPath(String targetPath) {
        this.targetPath = targetPath;
    }

    public void setInfinispanPath(String infinispanPath) {
        this.infinispanPath = infinispanPath;
    }

    public void addExtraCommandLineArgument(String argumentName, String argumentValue) {
        this.extraCommandArguments.put(argumentName, argumentValue);
    }

    public void addSingleCommandLineArgument(String argument) {
        this.singleCommandArguments.add(argument);
    }

    public void setCommandLineExecutor(CommandLineExecutor commandLineExecutor) {
        this.commandLineExecutor = commandLineExecutor;
    }

    public void setOperatingSystemResolver(OperatingSystemResolver operatingSystemResolver) {
        this.operatingSystemResolver = operatingSystemResolver;
    }

    private File ensureTargetPathDoesNotExitsAndReturnCompositePath() {
        File dbPath = new File(this.targetPath);
        if (dbPath.exists()) {
            IOUtils.deleteDir((File)dbPath);
        }
        return dbPath;
    }
}

