/*
 * Decompiled with CFR 0.152.
 */
package com.lordofthejars.nosqlunit.infinispan;

import com.lordofthejars.nosqlunit.core.FailureHandler;
import java.util.Map;
import java.util.Set;
import org.infinispan.api.BasicCache;

public class InfinispanAssertion {
    public static void strictAssertEquals(BasicCache<Object, Object> cache, Map<Object, Object> expectedMap) {
        int expectedNumberOfKeys = expectedMap.size();
        int currentNumberOfKeys = cache.size();
        InfinispanAssertion.checkNumberOfElements(expectedNumberOfKeys, currentNumberOfKeys);
        InfinispanAssertion.checkElements(cache, expectedMap);
    }

    private static void checkElements(BasicCache<Object, Object> cache, Map<Object, Object> expectedMap) throws Error {
        Set<Map.Entry<Object, Object>> expectedElements = expectedMap.entrySet();
        for (Map.Entry<Object, Object> expectedElement : expectedElements) {
            InfinispanAssertion.checkElement(cache, expectedElement);
        }
    }

    private static void checkElement(BasicCache<Object, Object> cache, Map.Entry<Object, Object> expectedElement) throws Error {
        Object expectedKey = expectedElement.getKey();
        if (cache.containsKey(expectedKey)) {
            Object expectedValue;
            Object currentValue = cache.get(expectedKey);
            if (!currentValue.equals(expectedValue = expectedElement.getValue())) {
                throw FailureHandler.createFailure((String)"Object for key %s should be %s but was found %s.", (Object[])new Object[]{expectedKey, expectedValue, currentValue});
            }
        } else {
            throw FailureHandler.createFailure((String)"Key %s was not found.", (Object[])new Object[]{expectedKey});
        }
    }

    private static void checkNumberOfElements(int expectedNumberOfKeys, int currentNumberOfKeys) throws Error {
        if (expectedNumberOfKeys != currentNumberOfKeys) {
            throw FailureHandler.createFailure((String)"Number of expected keys are %s but was found %s.", (Object[])new Object[]{expectedNumberOfKeys, currentNumberOfKeys});
        }
    }
}

