/*
 * Decompiled with CFR 0.152.
 */
package com.lordofthejars.nosqlunit.infinispan;

import com.lordofthejars.nosqlunit.core.AbstractLifecycleManager;
import com.lordofthejars.nosqlunit.infinispan.EmbeddedInfinispanInstancesFactory;
import java.io.File;
import java.io.IOException;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.manager.DefaultCacheManager;
import org.infinispan.manager.EmbeddedCacheManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmbeddedInfinispanLifecycleManager
extends AbstractLifecycleManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(EmbeddedInfinispanLifecycleManager.class);
    protected static final String LOCALHOST = "127.0.0.1";
    protected static final int PORT = 11222;
    public static final String INMEMORY_INFINISPAN_TARGET_PATH = "target" + File.separatorChar + "infinispan-test-data" + File.separatorChar + "impermanent-db";
    private String targetPath = INMEMORY_INFINISPAN_TARGET_PATH;
    private String configurationFile = null;

    public String getHost() {
        return LOCALHOST + this.targetPath;
    }

    public int getPort() {
        return 11222;
    }

    public void doStart() throws Throwable {
        LOGGER.info("Starting Embedded Infinispan instance.");
        EmbeddedCacheManager embeddedCacheManager = this.embeddedCacheManager();
        EmbeddedInfinispanInstancesFactory.getInstance().addEmbeddedInstance((Object)embeddedCacheManager, this.targetPath);
        LOGGER.info("Started Embedded Infinispan instance.");
    }

    public void doStop() {
        LOGGER.info("Stopping Embedded Infinispan instance.");
        EmbeddedInfinispanInstancesFactory.getInstance().removeEmbeddedInstance(this.targetPath);
        LOGGER.info("Stopped Embedded Infinispan instance.");
    }

    private EmbeddedCacheManager embeddedCacheManager() throws IOException {
        if (this.configurationFile == null) {
            GlobalConfigurationBuilder global = new GlobalConfigurationBuilder();
            global.globalJmxStatistics().allowDuplicateDomains(Boolean.valueOf(true));
            return new DefaultCacheManager(global.build(), new ConfigurationBuilder().build());
        }
        return new DefaultCacheManager(this.configurationFile);
    }

    public void setTargetPath(String targetPath) {
        this.targetPath = targetPath;
    }

    public String getTargetPath() {
        return this.targetPath;
    }

    public void setConfigurationFile(String configurationFile) {
        this.configurationFile = configurationFile;
    }
}

