/*
 * Decompiled with CFR 0.152.
 */
package com.lordofthejars.nosqlunit.infinispan;

import com.lordofthejars.nosqlunit.core.AbstractNoSqlTestRule;
import com.lordofthejars.nosqlunit.core.DatabaseOperation;
import com.lordofthejars.nosqlunit.infinispan.EmbeddedInfinispanConfigurationBuilder;
import com.lordofthejars.nosqlunit.infinispan.InfinispanConfiguration;
import com.lordofthejars.nosqlunit.infinispan.InfinispanOperation;
import com.lordofthejars.nosqlunit.infinispan.ManagedInfinispanConfigurationBuilder;
import org.infinispan.commons.api.BasicCache;

public class InfinispanRule
extends AbstractNoSqlTestRule {
    private static final String EXTENSION = "json";
    private DatabaseOperation<BasicCache<Object, Object>> databaseOperation;

    public InfinispanRule(InfinispanConfiguration infinispanConfiguration) {
        super(infinispanConfiguration.getConnectionIdentifier());
        this.databaseOperation = new InfinispanOperation(infinispanConfiguration.getCache());
    }

    public InfinispanRule(InfinispanConfiguration infinispanConfiguration, Object target) {
        this(infinispanConfiguration);
        this.setTarget(target);
    }

    public DatabaseOperation<BasicCache<Object, Object>> getDatabaseOperation() {
        return this.databaseOperation;
    }

    public String getWorkingExtension() {
        return EXTENSION;
    }

    public void close() {
    }

    public static class InfinispanRuleBuilder {
        private InfinispanConfiguration infinispanConfiguration;
        private Object target;

        private InfinispanRuleBuilder() {
        }

        public static InfinispanRuleBuilder newInfinispanRule() {
            return new InfinispanRuleBuilder();
        }

        public InfinispanRuleBuilder configure(InfinispanConfiguration infinispanConfiguration) {
            this.infinispanConfiguration = infinispanConfiguration;
            return this;
        }

        public InfinispanRuleBuilder unitInstance(Object target) {
            this.target = target;
            return this;
        }

        public InfinispanRule defaultEmbeddedInfinispan() {
            return new InfinispanRule(EmbeddedInfinispanConfigurationBuilder.newEmbeddedInfinispanConfiguration().build());
        }

        @Deprecated
        public InfinispanRule defaultEmbeddedInfinispan(Object target) {
            return new InfinispanRule(EmbeddedInfinispanConfigurationBuilder.newEmbeddedInfinispanConfiguration().build(), target);
        }

        public InfinispanRule defaultManagedInfinispan() {
            return new InfinispanRule(ManagedInfinispanConfigurationBuilder.newManagedInfinispanConfiguration().build());
        }

        public InfinispanRule defaultManagedInfinispan(int port) {
            return new InfinispanRule(ManagedInfinispanConfigurationBuilder.newManagedInfinispanConfiguration().port(port).build());
        }

        @Deprecated
        public InfinispanRule defaultManagedInfinispan(Object target) {
            return new InfinispanRule(ManagedInfinispanConfigurationBuilder.newManagedInfinispanConfiguration().build(), target);
        }

        public InfinispanRule build() {
            if (this.infinispanConfiguration == null) {
                throw new IllegalArgumentException("Configuration object should be provided.");
            }
            return new InfinispanRule(this.infinispanConfiguration, this.target);
        }
    }
}

