/*
 * Decompiled with CFR 0.152.
 */
package com.lordofthejars.nosqlunit.mongodb;

import com.lordofthejars.nosqlunit.core.AbstractNoSqlTestRule;
import com.lordofthejars.nosqlunit.core.DatabaseOperation;
import com.lordofthejars.nosqlunit.mongodb.InMemoryMongoDbConfigurationBuilder;
import com.lordofthejars.nosqlunit.mongodb.MongoDbConfiguration;
import com.lordofthejars.nosqlunit.mongodb.MongoDbConfigurationBuilder;
import com.lordofthejars.nosqlunit.mongodb.MongoOperation;
import com.lordofthejars.nosqlunit.mongodb.SpringMongoDbRule;
import com.mongodb.Mongo;
import com.mongodb.MongoException;

public class MongoDbRule
extends AbstractNoSqlTestRule {
    private static final String EXTENSION = "json";
    protected DatabaseOperation<Mongo> databaseOperation;

    public MongoDbRule(MongoDbConfiguration mongoDbConfiguration) {
        super(mongoDbConfiguration.getConnectionIdentifier());
        try {
            this.databaseOperation = new MongoOperation(mongoDbConfiguration);
        }
        catch (MongoException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public MongoDbRule(MongoDbConfiguration mongoDbConfiguration, Object target) {
        super(mongoDbConfiguration.getConnectionIdentifier());
        try {
            this.setTarget(target);
            this.databaseOperation = new MongoOperation(mongoDbConfiguration);
        }
        catch (MongoException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public DatabaseOperation<Mongo> getDatabaseOperation() {
        return this.databaseOperation;
    }

    public String getWorkingExtension() {
        return EXTENSION;
    }

    public static class MongoDbRuleBuilder {
        private MongoDbConfiguration mongoDbConfiguration;
        private Object target;

        private MongoDbRuleBuilder() {
        }

        public static MongoDbRuleBuilder newMongoDbRule() {
            return new MongoDbRuleBuilder();
        }

        public MongoDbRuleBuilder configure(MongoDbConfiguration mongoDbConfiguration) {
            this.mongoDbConfiguration = mongoDbConfiguration;
            return this;
        }

        public MongoDbRuleBuilder unitInstance(Object target) {
            this.target = target;
            return this;
        }

        public MongoDbRule defaultEmbeddedMongoDb(String databaseName) {
            return new MongoDbRule(InMemoryMongoDbConfigurationBuilder.inMemoryMongoDb().databaseName(databaseName).build());
        }

        @Deprecated
        public MongoDbRule defaultEmbeddedMongoDb(String databaseName, Object target) {
            return new MongoDbRule(InMemoryMongoDbConfigurationBuilder.inMemoryMongoDb().databaseName(databaseName).build(), target);
        }

        public MongoDbRule defaultManagedMongoDb(String databaseName) {
            return new MongoDbRule(MongoDbConfigurationBuilder.mongoDb().databaseName(databaseName).build());
        }

        public MongoDbRule defaultManagedMongoDb(String databaseName, int port) {
            return new MongoDbRule(MongoDbConfigurationBuilder.mongoDb().databaseName(databaseName).port(port).build());
        }

        public MongoDbRule defaultSpringMongoDb(String databaseName) {
            return new SpringMongoDbRule(MongoDbConfigurationBuilder.mongoDb().databaseName(databaseName).build());
        }

        @Deprecated
        public MongoDbRule defaultManagedMongoDb(String databaseName, Object target) {
            return new MongoDbRule(MongoDbConfigurationBuilder.mongoDb().databaseName(databaseName).build(), target);
        }

        public MongoDbRule build() {
            if (this.mongoDbConfiguration == null) {
                throw new IllegalArgumentException("Configuration object should be provided.");
            }
            return new MongoDbRule(this.mongoDbConfiguration, this.target);
        }
    }
}

