/*
 * Decompiled with CFR 0.152.
 */
package com.lordofthejars.nosqlunit.mongodb;

import com.lordofthejars.nosqlunit.mongodb.replicaset.ConfigurationDocument;
import com.mongodb.BasicDBObject;
import com.mongodb.CommandResult;
import com.mongodb.DB;
import com.mongodb.DBObject;
import com.mongodb.MongoClient;
import com.mongodb.client.MongoDatabase;
import java.util.Set;
import org.bson.Document;
import org.bson.conversions.Bson;

public class MongoDbCommands {
    private static final String REPL_SET_GET_STATUS_COMMAND = "replSetGetStatus";
    private static final String REPL_SET_INITIATE_COMMAND = "replSetInitiate";
    private static final String RECONFIG_COMMAND = "replSetReconfig";
    private static final String ADD_SHARD_COMMAND = "addshard";
    private static final String ENABLE_SHARDING_COMMAND = "enablesharding";
    private static final String SHARD_COLLECTION_COMMAND = "shardcollection";
    private static final String LIST_SHARDS_COMMAND = "listShards";

    private MongoDbCommands() {
    }

    public static Document replicaSetGetStatus(MongoClient mongoClient) {
        return mongoClient.getDatabase("admin").runCommand((Bson)new Document(REPL_SET_GET_STATUS_COMMAND, (Object)1));
    }

    public static Document shardCollection(MongoClient mongoClient, String collectionWithDatabase, Document shardKey) {
        MongoDatabase adminDb = MongoDbCommands.getAdminDatabase(mongoClient);
        Document basicDBObject = new Document(SHARD_COLLECTION_COMMAND, (Object)collectionWithDatabase);
        basicDBObject.append("key", (Object)shardKey);
        return adminDb.runCommand((Bson)basicDBObject);
    }

    public static Document enableSharding(MongoClient mongoClient, String database) {
        MongoDatabase adminDb = MongoDbCommands.getAdminDatabase(mongoClient);
        return adminDb.runCommand((Bson)new Document(ENABLE_SHARDING_COMMAND, (Object)database));
    }

    public static Document listShards(MongoClient mongoClient) {
        MongoDatabase adminDb = MongoDbCommands.getAdminDatabase(mongoClient);
        return adminDb.runCommand((Bson)new Document(LIST_SHARDS_COMMAND, (Object)1));
    }

    public static void addShard(MongoClient mongoClient, Set<String> shards) {
        MongoDatabase adminDb = MongoDbCommands.getAdminDatabase(mongoClient);
        for (String shardUri : shards) {
            adminDb.runCommand((Bson)new Document(ADD_SHARD_COMMAND, (Object)shardUri));
        }
    }

    public static Document replicaSetInitiate(MongoClient mongoClient, ConfigurationDocument configurationDocument) {
        MongoDatabase adminDb = MongoDbCommands.getAdminDatabase(mongoClient);
        Document command = new Document(REPL_SET_INITIATE_COMMAND, (Object)configurationDocument.getConfiguration());
        return adminDb.runCommand((Bson)command);
    }

    private static MongoDatabase getAdminDatabase(MongoClient mongoClient) {
        MongoDatabase adminDb = mongoClient.getDatabase("admin");
        return adminDb;
    }

    public static Document replSetReconfig(MongoClient mongoClient, ConfigurationDocument configurationDocument) {
        MongoDatabase adminDb = MongoDbCommands.getAdminDatabase(mongoClient);
        Document command = new Document(RECONFIG_COMMAND, (Object)configurationDocument.getConfiguration());
        return adminDb.runCommand((Bson)command);
    }

    public static void shutdown(String host, int port) {
        try (MongoClient mongo = null;){
            mongo = new MongoClient(host, port);
            DB db = mongo.getDB("admin");
            CommandResult shutdownResult = db.command((DBObject)new BasicDBObject("shutdown", (Object)1));
            shutdownResult.throwOnError();
        }
    }
}

