/*
 * Decompiled with CFR 0.152.
 */
package com.lordofthejars.nosqlunit.mongodb;

import com.lordofthejars.nosqlunit.core.IOUtils;
import com.lordofthejars.nosqlunit.mongodb.MongoComparisonStrategy;
import com.lordofthejars.nosqlunit.mongodb.MongoDbAssertion;
import com.lordofthejars.nosqlunit.mongodb.MongoDbConnectionCallback;
import java.io.IOException;
import java.io.InputStream;
import org.bson.Document;

public class MongoFlexibleComparisonStrategy
implements MongoComparisonStrategy {
    private String[] ignorePropertyValues = new String[0];

    public boolean compare(MongoDbConnectionCallback connection, InputStream dataset) throws IOException {
        String expectedJsonData = this.loadContentFromInputStream(dataset);
        Document parsedData = this.parseData(expectedJsonData);
        MongoDbAssertion.flexibleAssertEquals(parsedData, this.ignorePropertyValues, connection.db());
        return true;
    }

    private String loadContentFromInputStream(InputStream inputStreamContent) throws IOException {
        return IOUtils.readFullStream((InputStream)inputStreamContent);
    }

    private Document parseData(String jsonData) throws IOException {
        Document parsedData = Document.parse((String)jsonData);
        return parsedData;
    }

    public void setIgnoreProperties(String[] ignorePropertyValues) {
        this.ignorePropertyValues = ignorePropertyValues;
    }
}

