/*
 * Decompiled with CFR 0.152.
 */
package com.lordofthejars.nosqlunit.mongodb;

import com.lordofthejars.nosqlunit.core.FailureHandler;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.MongoIterable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MongoDbAssertion {
    private static final String SYSTEM_COLLECTIONS_PATTERN = "system.";
    private static final String DATA = "data";
    private static final Logger logger = LoggerFactory.getLogger(MongoDbAssertion.class);

    private MongoDbAssertion() {
    }

    public static final void strictAssertEquals(Document expectedData, MongoDatabase mongoDb) {
        Set collectionaNames = expectedData.keySet();
        MongoIterable collectionNames = mongoDb.listCollectionNames();
        MongoDbAssertion.checkCollectionsName(collectionaNames, (MongoIterable<String>)collectionNames);
        for (String collectionName : collectionaNames) {
            MongoDbAssertion.checkCollectionObjects(expectedData, mongoDb, collectionaNames, collectionName);
        }
    }

    private static void checkCollectionsName(Set<String> expectedCollectionNames, MongoIterable<String> mongodbCollectionNames) {
        Set<String> mongoDbUserCollectionNames = MongoDbAssertion.getUserCollections(mongodbCollectionNames);
        HashSet<String> allCollections = new HashSet<String>(mongoDbUserCollectionNames);
        allCollections.addAll(expectedCollectionNames);
        if (allCollections.size() != expectedCollectionNames.size() || allCollections.size() != mongoDbUserCollectionNames.size()) {
            throw FailureHandler.createFailure((String)"Expected collection names are %s but insert collection names are %s", (Object[])new Object[]{expectedCollectionNames, mongoDbUserCollectionNames});
        }
    }

    private static Set<String> getUserCollections(MongoIterable<String> mongodbCollectionNames) {
        HashSet<String> mongoDbUserCollectionNames = new HashSet<String>();
        for (String mongodbCollectionName : mongodbCollectionNames) {
            if (!MongoDbAssertion.isUserCollection(mongodbCollectionName)) continue;
            mongoDbUserCollectionNames.add(mongodbCollectionName);
        }
        return mongoDbUserCollectionNames;
    }

    private static boolean isUserCollection(String mongodbCollectionName) {
        return !mongodbCollectionName.contains(SYSTEM_COLLECTIONS_PATTERN);
    }

    private static void checkCollectionObjects(Document expectedData, MongoDatabase mongoDb, Set<String> collectionaNames, String collectionName) throws Error {
        long insertedDataObjectsCount;
        Object object = expectedData.get((Object)collectionName);
        List dataObjects = null;
        dataObjects = MongoDbAssertion.isDataDirectly(object) ? (List)object : (List)((Document)object).get((Object)DATA, List.class);
        MongoCollection dbCollection = mongoDb.getCollection(collectionName);
        int expectedDataObjectsCount = dataObjects.size();
        if ((long)expectedDataObjectsCount != (insertedDataObjectsCount = dbCollection.count())) {
            throw FailureHandler.createFailure((String)"Expected collection has %s elements but insert collection has %s", (Object[])new Object[]{expectedDataObjectsCount, insertedDataObjectsCount});
        }
        for (Document expectedDataObject : dataObjects) {
            Document foundObject = (Document)dbCollection.find((Bson)expectedDataObject).first();
            if (!MongoDbAssertion.exists(foundObject)) {
                throw FailureHandler.createFailure((String)"Object # %s # is not found into collection %s", (Object[])new Object[]{expectedDataObject.toString(), collectionaNames});
            }
            MongoDbAssertion.checkSameKeys(expectedDataObject, foundObject);
        }
    }

    private static boolean isDataDirectly(Object object) {
        return List.class.isAssignableFrom(object.getClass());
    }

    private static void checkSameKeys(Document expectedDataObject, Document foundObject) {
        Set expectedKeys = expectedDataObject.keySet();
        Set<String> expectedNoneSystemKeys = MongoDbAssertion.noneSystemKeys(expectedKeys);
        Set foundKeys = foundObject.keySet();
        Set<String> foundNoneSystemKeys = MongoDbAssertion.noneSystemKeys(foundKeys);
        HashSet<String> allKeys = new HashSet<String>(expectedNoneSystemKeys);
        allKeys.addAll(foundNoneSystemKeys);
        if (allKeys.size() != expectedNoneSystemKeys.size() || allKeys.size() != foundNoneSystemKeys.size()) {
            throw FailureHandler.createFailure((String)"Expected DbObject and insert DbObject have different keys: Expected: %s Inserted: %s", (Object[])new Object[]{expectedNoneSystemKeys, foundNoneSystemKeys});
        }
    }

    private static Set<String> noneSystemKeys(Set<String> keys) {
        HashSet<String> noneSystemKeys = new HashSet<String>();
        for (String key : keys) {
            if (key.startsWith("_")) continue;
            noneSystemKeys.add(key);
        }
        return noneSystemKeys;
    }

    private static boolean exists(Document foundObject) {
        return foundObject != null;
    }

    public static void flexibleAssertEquals(Document expectedData, String[] ignorePropertyValues, MongoDatabase mongoDb) {
        Set collectionNames = expectedData.keySet();
        MongoIterable listCollectionNames = mongoDb.listCollectionNames();
        Map<String, Set<String>> propertiesToIgnore = MongoDbAssertion.parseIgnorePropertyValues(collectionNames, ignorePropertyValues);
        MongoDbAssertion.flexibleCheckCollectionsName(collectionNames, (MongoIterable<String>)listCollectionNames);
        for (String collectionName : collectionNames) {
            MongoDbAssertion.flexibleCheckCollectionObjects(expectedData, mongoDb, collectionName, propertiesToIgnore);
        }
    }

    private static Map<String, Set<String>> parseIgnorePropertyValues(Set<String> collectionNames, String[] ignorePropertyValues) {
        HashMap<String, Set<String>> propertiesToIgnore = new HashMap<String, Set<String>>();
        Pattern collectionAndPropertyPattern = Pattern.compile("^(?!system\\.)([a-z,A-Z,_][^$\u0000]*)([.])([^$][^.\u0000]*)$");
        Pattern propertyPattern = Pattern.compile("^([^$][^.0]*)$");
        for (String ignorePropertyValue : ignorePropertyValues) {
            Matcher collectionAndPropertyMatcher = collectionAndPropertyPattern.matcher(ignorePropertyValue);
            Matcher propertyMatcher = propertyPattern.matcher(ignorePropertyValue);
            if (collectionAndPropertyMatcher.matches()) {
                String collectionName = collectionAndPropertyMatcher.group(1);
                String propertyName = collectionAndPropertyMatcher.group(3);
                if (collectionNames.contains(collectionName)) {
                    HashSet<String> properties = (HashSet<String>)propertiesToIgnore.get(collectionName);
                    if (properties == null) {
                        properties = new HashSet<String>();
                    }
                    properties.add(propertyName);
                    propertiesToIgnore.put(collectionName, properties);
                    continue;
                }
                logger.warn(String.format("Collection %s for %s is not defined as expected. It won't be used for ignoring properties", collectionName, ignorePropertyValue));
                continue;
            }
            if (propertyMatcher.matches()) {
                String propertyName = propertyMatcher.group(0);
                for (String collectionName : collectionNames) {
                    HashSet<String> properties = (HashSet<String>)propertiesToIgnore.get(collectionName);
                    if (properties == null) {
                        properties = new HashSet<String>();
                    }
                    properties.add(propertyName);
                    propertiesToIgnore.put(collectionName, properties);
                }
                continue;
            }
            logger.warn(String.format("Property %s has an invalid collection.property value. It won't be used for ignoring properties", ignorePropertyValue));
        }
        return propertiesToIgnore;
    }

    private static void flexibleCheckCollectionsName(Set<String> expectedCollectionNames, MongoIterable<String> mongodbCollectionNames) {
        Set<String> mongoDbUserCollectionNames = MongoDbAssertion.getUserCollections(mongodbCollectionNames);
        boolean ok = true;
        HashSet<String> notFoundCollectionNames = new HashSet<String>();
        for (String expectedCollectionName : expectedCollectionNames) {
            if (mongoDbUserCollectionNames.contains(expectedCollectionName)) continue;
            ok = false;
            notFoundCollectionNames.add(expectedCollectionName);
        }
        if (!ok) {
            throw FailureHandler.createFailure((String)"The following collection names %s were not found in the inserted collection names", (Object[])new Object[]{notFoundCollectionNames});
        }
    }

    private static void flexibleCheckCollectionObjects(Document expectedData, MongoDatabase mongoDb, String collectionName, Map<String, Set<String>> propertiesToIgnore) throws Error {
        Object object = expectedData.get((Object)collectionName);
        List dataObjects = null;
        dataObjects = MongoDbAssertion.isDataDirectly(object) ? (List)object : (List)((Document)object).get((Object)DATA, List.class);
        MongoCollection dbCollection = mongoDb.getCollection(collectionName);
        for (Document expectedDataObject : dataObjects) {
            Document filteredExpectedDataObject = MongoDbAssertion.filterProperties(expectedDataObject, propertiesToIgnore.get(collectionName));
            Document foundObject = (Document)dbCollection.find((Bson)filteredExpectedDataObject).first();
            if (dbCollection.count((Bson)filteredExpectedDataObject) > 1L) {
                logger.warn(String.format("There were found %d possible matches for this object # %s #. That could have been caused by ignoring too many properties.", dbCollection.count((Bson)filteredExpectedDataObject), expectedDataObject.toString()));
            }
            if (!MongoDbAssertion.exists(foundObject)) {
                throw FailureHandler.createFailure((String)"Object # %s # is not found into collection %s", (Object[])new Object[]{filteredExpectedDataObject.toString(), collectionName});
            }
            MongoDbAssertion.flexibleCheckSameKeys(expectedDataObject, foundObject);
        }
    }

    private static Document filterProperties(Document dataObject, Set<String> propertiesToIgnore) {
        Document filteredDataObject = new Document();
        for (Map.Entry entry : dataObject.entrySet()) {
            if (propertiesToIgnore != null && propertiesToIgnore.contains(entry.getKey())) continue;
            filteredDataObject.put((String)entry.getKey(), entry.getValue());
        }
        return filteredDataObject;
    }

    private static void flexibleCheckSameKeys(Document expectedDataObject, Document foundObject) {
        Set expectedKeys = expectedDataObject.keySet();
        Set<String> expectedNoneSystemKeys = MongoDbAssertion.noneSystemKeys(expectedKeys);
        Set foundKeys = foundObject.keySet();
        Set<String> foundNoneSystemKeys = MongoDbAssertion.noneSystemKeys(foundKeys);
        HashSet<String> allKeys = new HashSet<String>(expectedNoneSystemKeys);
        allKeys.addAll(foundNoneSystemKeys);
        HashSet<String> expectedKeysNotInserted = new HashSet<String>();
        HashSet<String> insertedKeysNotExpected = new HashSet<String>();
        for (String key : allKeys) {
            if (!expectedNoneSystemKeys.contains(key)) {
                insertedKeysNotExpected.add(key);
            }
            if (foundNoneSystemKeys.contains(key)) continue;
            expectedKeysNotInserted.add(key);
        }
        if (expectedKeysNotInserted.size() > 0 || insertedKeysNotExpected.size() > 0) {
            StringBuilder errorMessage = new StringBuilder("Expected Document and insert Document have different keys: ");
            if (expectedKeysNotInserted.size() > 0) {
                errorMessage.append("expected keys not inserted ").append(expectedKeysNotInserted).append(" ");
            }
            if (insertedKeysNotExpected.size() > 0) {
                errorMessage.append("inserted keys not expected ").append(insertedKeysNotExpected).append(" ");
            }
            throw FailureHandler.createFailure((String)errorMessage.toString(), (Object[])new Object[0]);
        }
    }
}

