/*
 * Decompiled with CFR 0.152.
 */
package com.lordofthejars.nosqlunit.mongodb;

import com.lordofthejars.nosqlunit.mongodb.MongoDbCommands;
import com.mongodb.MongoClient;
import com.mongodb.MongoException;
import com.mongodb.client.MongoDatabase;
import com.mongodb.util.JSON;
import java.net.UnknownHostException;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.bson.Document;
import org.bson.conversions.Bson;

public class MongoDbLowLevelOps {
    private static final String MEMBERS_TOKEN = "members";
    private static final int WAIT_TIME = 6;
    private static final int MAX_RETRIES = 20;
    private static final String STATE_TOKEN = "state";
    private static final Integer STARTING_UP_1 = 0;
    private static final Integer PRIMARY = 1;
    private static final Integer SECONDARY = 2;
    private static final Integer RECOVERING = 3;
    private static final Integer FATAL_ERROR = 4;
    private static final Integer STARTING_UP_2 = 5;
    private static final Integer UNKNOWN = 6;
    private static final Integer ARBITER = 7;
    private static final Integer DOWN = 8;

    MongoDbLowLevelOps() {
    }

    public void waitUntilReplicaSetBecomeStable(MongoClient mongoClient, int numberOfServersStable, String ... authenticateParameters) {
        boolean isConfigurationSpread = false;
        int retries = 0;
        while (!isConfigurationSpread) {
            try {
                TimeUnit.SECONDS.sleep(6L);
            }
            catch (InterruptedException e) {
                throw new IllegalStateException(e);
            }
            Document status = null;
            try {
                status = this.getStatus(mongoClient, authenticateParameters);
                isConfigurationSpread = this.isSystemStable(status, numberOfServersStable);
            }
            catch (MongoException e) {
                status = new Document("MongoException", (Object)"can't find a master");
                isConfigurationSpread = false;
            }
            if (++retries <= 20 || isConfigurationSpread) continue;
            mongoClient.close();
            throw new IllegalStateException("After 120 seconds replica set scenario could not be started and configured. Last status message was: " + JSON.serialize((Object)status));
        }
    }

    private Document getStatus(MongoClient mongoClient, String ... authenticateParameters) {
        Document status = null;
        status = authenticateParameters.length == 2 ? this.getMongosStatus(mongoClient, authenticateParameters[0], authenticateParameters[1]) : this.getMongosStatus(mongoClient);
        return status;
    }

    private boolean isSystemStable(Document status, int numberOfServersStable) {
        int currentNumberOfStables = 0;
        List members = (List)status.get((Object)MEMBERS_TOKEN, List.class);
        if (members == null) {
            return false;
        }
        for (Document member : members) {
            if (!member.get((Object)STATE_TOKEN).equals(PRIMARY) && !member.get((Object)STATE_TOKEN).equals(SECONDARY) && !member.get((Object)STATE_TOKEN).equals(ARBITER)) continue;
            ++currentNumberOfStables;
        }
        return currentNumberOfStables == numberOfServersStable;
    }

    private Document getMongosStatus(MongoClient mongoClient, String username, String password) {
        return MongoDbCommands.replicaSetGetStatus(mongoClient);
    }

    private Document getMongosStatus(MongoClient mongoClient) {
        return MongoDbCommands.replicaSetGetStatus(mongoClient);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean assertThatConnectionIsPossible(String host, int port) throws InterruptedException, UnknownHostException, MongoException {
        int currentRetry = 0;
        boolean connectionIsPossible = false;
        try (MongoClient server = null;){
            do {
                TimeUnit.SECONDS.sleep(6L);
                server = new MongoClient(host, port);
                MongoDatabase db = server.getDatabase("admin");
                try {
                    db.runCommand((Bson)Document.parse((String)"{ dbStats: 1, scale: 1 }"));
                    connectionIsPossible = true;
                }
                catch (MongoException e) {
                    ++currentRetry;
                }
            } while (!connectionIsPossible && currentRetry <= 20);
        }
        return connectionIsPossible;
    }

    public void shutdown(String host, int port) {
        MongoDbCommands.shutdown(host, port);
    }
}

