/*
 * Decompiled with CFR 0.152.
 */
package com.lordofthejars.nosqlunit.redis.embedded;

public class BitsUtils {
    public static byte[] extendByteArrayBy(byte[] data, int numberOfNewPositions) {
        byte[] newSize = new byte[data.length + numberOfNewPositions];
        System.arraycopy(data, 0, newSize, 0, data.length);
        return newSize;
    }

    public static boolean toBoolean(int bit) {
        if (bit == 0) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    public static int countBits(byte num) {
        int count = 0;
        int i = 0;
        while (i < 8) {
            if ((num & 1) == 1) {
                ++count;
            }
            num = (byte)(num >>> 1);
            ++i;
        }
        return count;
    }

    public static int calculateNumberOfBytes(int numBits) {
        int numberOfBytes = numBits / 8;
        if (numBits % 8 > 0) {
            ++numberOfBytes;
        }
        return numberOfBytes;
    }

    public static int getBit(byte[] data, int pos) {
        int posByte = pos / 8;
        int posBit = pos % 8;
        byte valByte = data[posByte];
        int valInt = valByte >> 8 - (posBit + 1) & 1;
        return valInt;
    }

    public static void setBit(byte[] data, int pos, int val) {
        byte newByte;
        int posByte = pos / 8;
        int posBit = pos % 8;
        byte oldByte = data[posByte];
        oldByte = (byte)(65407 >> posBit & oldByte & 0xFF);
        data[posByte] = newByte = (byte)(val << 8 - (posBit + 1) | oldByte);
    }
}

